/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.cache;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.search.index.IndexerStatus;

@JsonData
public class HelpDeskTicketSearchCacheAction
extends MaintenanceCacheAction
implements ConnectionCreationListener {
    private boolean connectionCreated;

    public HelpDeskTicketSearchCacheAction() {
        super("reloadTicketSearchCache");
    }

    public void updateAction() {
        boolean ticketIndexInitialized = VetoManager.getInstance().isAlreadyProcessed(TicketManagerVetoPower.TYPE);
        if (!ticketIndexInitialized) {
            this.setEnabled(false);
            this.setTitle(HelpDeskMaintenanceServerPlugin.MSG.getMsg("ticketSearchCacheAction.title.waiting", new Object[0]));
            return;
        }
        MaintenanceConnector maintenanceConnector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        IndexerStatus indexerStatus = maintenanceConnector.getIndexerStatus();
        IndexerStatus stepIdxStatus = maintenanceConnector.getReaStepIndexerStatus();
        this.setEnabled(this.connectionCreated && !indexerStatus.isRunning() && !stepIdxStatus.isRunning());
        String msgKey = this.isEnabled() ? "ticketSearchCacheAction.title.enabled" : "ticketSearchCacheAction.title.disabled";
        this.setTitle(HelpDeskMaintenanceServerPlugin.MSG.getMsg(msgKey, new Object[0]));
    }

    public String executeAction() throws ClientMessageException {
        MaintenanceConnector maintenanceConnector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        maintenanceConnector.triggerIndexer();
        TicketManager.getMaintenance().clearAllTicketsInCache();
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("actionresult.indexerstarted", new Object[0]);
    }

    public void connectionCreated() {
        this.connectionCreated = true;
    }
}

