/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.PreviewEntry;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.http.servlet.ClientLocale;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonData
public class TicketPreviewEntry
extends PreviewEntry<Ticket> {
    private static final List<Field> ORDER_FIELDS = Arrays.asList(Field.TICKETDATA_OWNER, Field.TICKETDATA_INQUIRYDATE, Field.TICKETDATA_LASTTEXTEDITOR, Field.TICKETDATA_LASTMODIFIED, Field.TICKETDATA_RESOURCEID_DISPLAYNAME, Field.TICKETDATA_PRIORITYID, Field.TICKETDATA_CATEGORY);

    public TicketPreviewEntry from(Ticket value) throws ServerDataException {
        DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(3, 3, ClientLocale.getThreadLocale());
        this.setTitle("#" + value.getId() + " " + (String)value.getValue(Field.TICKETDATA_SUBJECT, String.class));
        this.setIcon("images/data/0/" + String.valueOf(value.getValue(Field.TICKETDATA_STATUSID, Integer.class)) + "?size=64");
        ArrayList<LocalizedKey> details = new ArrayList<LocalizedKey>();
        for (Field field : ORDER_FIELDS) {
            PriorityVO priorityVO;
            com.inet.field.Field apiField;
            Object v = value.getValue(field, field.getClassType());
            if (v == null || (apiField = HDFieldLocator.getFieldForOldDbField((Field)field)) == null) continue;
            String key = apiField.getLabel();
            if (field == Field.TICKETDATA_PRIORITYID && v instanceof Integer && (priorityVO = (PriorityVO)PriorityManager.getInstance().get(((Integer)v).intValue())) != null) {
                v = priorityVO.getDisplayValue();
            }
            if (v instanceof User) {
                v = ((User)v).getDisplayName();
            }
            if (v instanceof Date) {
                v = dateTimeInstance.format(v);
            }
            if (v == null || v.toString().length() == 0) continue;
            details.add(new LocalizedKey(key, v.toString()));
        }
        this.setDetails(details);
        return this;
    }
}

