/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.cache;

import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.logging.LogManager;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.maintenance.api.cache.MaintenanceCacheExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.index.IndexerStatus;

public class HelpDeskTicketSearchCacheExtension
implements MaintenanceCacheExtension {
    private MaintenanceCacheAction cacheAction;

    public HelpDeskTicketSearchCacheExtension(MaintenanceCacheAction cacheAction) {
        this.cacheAction = cacheAction;
    }

    public MaintenanceCacheAction getCacheAction() {
        return this.cacheAction;
    }

    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("ticketSearchCache.title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("ticketSearchCache.description", new Object[0]);
    }

    public String getDetailsMessage() {
        MaintenanceConnector connector = this.getMaintenanceConnector();
        IndexerStatus indexerStatus = connector.getIndexerStatus();
        IndexerStatus stepIdxStatus = connector.getReaStepIndexerStatus();
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("ticketSearchCache.detailsmessage", new Object[]{indexerStatus.isRunning() ? 1 : 0, indexerStatus.getStatistics(), stepIdxStatus.isRunning() ? 1 : 0, stepIdxStatus.getStatistics()});
    }

    public String getDetailsLink() {
        return null;
    }

    public boolean getNeedsPolling() {
        MaintenanceConnector connector = this.getMaintenanceConnector();
        IndexerStatus indexerStatus = connector.getIndexerStatus();
        IndexerStatus stepIdxStatus = connector.getReaStepIndexerStatus();
        boolean running = indexerStatus.isRunning() || stepIdxStatus.isRunning();
        LogManager.getLogger((String)"Maintenance").debug((Object)("The HelpDesk Ticket Indexer is running: " + running));
        return running;
    }

    public int getProgress() {
        int progress;
        MaintenanceConnector connector = this.getMaintenanceConnector();
        IndexerStatus indexerStatus = connector.getIndexerStatus();
        IndexerStatus stepIdxStatus = connector.getReaStepIndexerStatus();
        long index1 = indexerStatus.getIndexed();
        long index2 = stepIdxStatus.getIndexed();
        if (index1 < 0L && index2 < 0L) {
            progress = 0;
        } else {
            if (index1 < 0L) {
                index1 = indexerStatus.getToBeIndexed();
            }
            if (index2 < 0L) {
                index2 = stepIdxStatus.getToBeIndexed();
            }
            long toBeIndexed = indexerStatus.getToBeIndexed() + stepIdxStatus.getToBeIndexed();
            progress = (int)Math.floor((double)(index1 + index2) / (double)toBeIndexed * 100.0);
        }
        LogManager.getLogger((String)"Maintenance").debug((Object)("Current HelpDesk Ticket Index Progress: " + progress + "%"));
        return progress;
    }

    private MaintenanceConnector getMaintenanceConnector() {
        return (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
    }
}

