/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.PreviewEntry;
import com.inet.helpdesk.shared.model.Field;
import java.util.ArrayList;

@JsonData
public class LocationPreviewEntry
extends PreviewEntry<Entry> {
    public LocationPreviewEntry from(Entry value) throws ServerDataException {
        this.setTitle(value.getDisplayName());
        this.setIcon("images/data/5/" + value.getId() + "?size=64");
        ArrayList<LocalizedKey> details = new ArrayList<LocalizedKey>();
        Object comment = value.getData(Field.LOCATION_COMMENT, null);
        if (comment != null) {
            details.add(new LocalizedKey(Field.LOCATION_COMMENT.getKey(), comment.toString()));
        }
        this.setDetails(details);
        return this;
    }

    public LocationPreviewEntry from(LocationVO value) {
        this.setTitle(value.getDisplayValue());
        this.setIcon("images/data/5/" + value.getId() + "?size=64");
        ArrayList<LocalizedKey> details = new ArrayList<LocalizedKey>();
        String comment = value.getComment();
        if (comment != null) {
            details.add(new LocalizedKey(Field.LOCATION_COMMENT.getKey(), comment.toString()));
        }
        this.setDetails(details);
        return this;
    }
}

