/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.PreviewEntry;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonData
public class UserPreviewEntry
extends PreviewEntry<MaintenanceConnector.UnrelatedUser> {
    private static final List<Field> ORDER_FIELDS = Arrays.asList(Field.USERDATA_USERNAME, Field.USERDATA_LASTNAME, Field.USERDATA_FIRSTNAME, Field.USERDATA_LOCATION_DISPLAYNAME, Field.USERDATA_GROUP_DISPLAYNAME, Field.USERDATA_TELEPHONE, Field.USERDATA_ROOM, Field.USERDATA_DEPARTMENT, Field.USERDATA_EMAIL, Field.USERDATA_COSTCENTRE);

    public UserPreviewEntry from(MaintenanceConnector.UnrelatedUser value) throws ServerDataException {
        this.setTitle(value.getDisplayName());
        String iconURL = "maintenance/?method=getrecoveryenableduserimage&round=true&accountid=" + value.getUserAccountID().toString();
        this.setIcon(iconURL);
        ArrayList<LocalizedKey> details = new ArrayList<LocalizedKey>();
        for (Field field : ORDER_FIELDS) {
            com.inet.field.Field apiField;
            Object v = value.getValue(field, field.getClassType());
            if (v == null || (apiField = HDFieldLocator.getFieldForOldDbField((Field)field)) == null) continue;
            String key = apiField.getLabel();
            if (v instanceof String[]) {
                String[] vArr = (String[])v;
                if (vArr.length == 0) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < vArr.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(vArr[i]);
                }
                details.add(new LocalizedKey(key, sb.toString()));
                continue;
            }
            v = apiField.getFieldType().getDisplayValue(v);
            if (v == null || v.toString().length() == 0) continue;
            details.add(new LocalizedKey(key, v.toString()));
        }
        this.setDetails(details);
        return this;
    }
}

