/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.dbmigration.handler;

import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.utils.SqlServerSearcher;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.data.CurrentDBSettingsResponseData;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.maintenance.api.MaintenanceHelper;
import java.util.ArrayList;
import javax.annotation.SuppressFBWarnings;

public class GetCurrentDBSettingsHandler
extends MaintenanceHandler<Void, CurrentDBSettingsResponseData> {
    public String getMethodName() {
        return "maintenance_dbmigration_getcurrentdbsettings";
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Sets the password for the migration")
    public CurrentDBSettingsResponseData invoke(Void input) throws ClientMessageException {
        String dbConfigValue = MaintenanceHelper.getCurrentConfiguration().get(HDConfigKeys.DB_CONFIGS.getKey(), HDConfigKeys.DB_CONFIGS.getDefault());
        DatabaseConfigInfoList dbConfigs = (DatabaseConfigInfoList)new Json().fromJson(dbConfigValue, DatabaseConfigInfoList.class);
        DatabaseConfigInfo hdsConfig = dbConfigs.get("HDS");
        if (hdsConfig != null) {
            String decodedPassword = hdsConfig.getDecodedPassword();
            if (decodedPassword.length() > 0) {
                hdsConfig.setEncodedPassword("set");
            } else {
                hdsConfig.setEncodedPassword("");
            }
        }
        DatabaseConfigInfoList availableMsSQLServer = SqlServerSearcher.generateList();
        return new CurrentDBSettingsResponseData(hdsConfig, (ArrayList<DatabaseConfigInfo>)availableMsSQLServer);
    }
}

