/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.loginmodification;

import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationResultResponseData;
import com.inet.helpdesk.usersandgroups.UserIterator;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LoginModificationDataAnalyzer {
    private String newDomainDisplay;
    private String newDomain;
    private String existingDomain;
    private List<String> newNames;
    private Set<String> alreadyExistingNames;
    private int problemCount = 0;
    private int activeUsers = 0;
    private int inactiveUsers = 0;

    protected LoginModificationDataAnalyzer(UserManager manager, String newDomain, String existingDomain) {
        this.newDomain = newDomain.toUpperCase();
        this.newDomainDisplay = newDomain;
        this.existingDomain = existingDomain.toUpperCase();
        this.newNames = new ArrayList<String>();
        this.alreadyExistingNames = new HashSet<String>();
        List accountLoginsList = new UserIterator().getUserSystemLogins(manager);
        for (UserIterator.AccountLogins accountLogins : accountLoginsList) {
            this.handleData(accountLogins);
        }
    }

    public void handleData(UserIterator.AccountLogins accountLogins) {
        boolean affected = false;
        for (UserIterator.LoginData systemLogin : accountLogins.getSystemLogins()) {
            if (this.existingDomain.equals(systemLogin.getDomain())) {
                String newName = this.newDomain + "\\" + systemLogin.getSimpleUserName().toUpperCase();
                this.newNames.add(newName);
                affected = true;
                continue;
            }
            if (!this.newDomain.equals(systemLogin.getDomain())) continue;
            this.alreadyExistingNames.add(systemLogin.getNormalizedUserName());
        }
        if (affected) {
            if (accountLogins.getUserAccount().isActive()) {
                ++this.activeUsers;
            } else {
                ++this.inactiveUsers;
            }
        }
    }

    protected LoginModificationResultResponseData generateResult(String msgKey) throws ClientMessageException {
        for (String existing : this.alreadyExistingNames) {
            HelpDeskMaintenanceServerPlugin.LOGGER.debug((Object)("EXIST -" + existing + "-"));
            if (!this.newNames.contains(existing)) continue;
            ++this.problemCount;
        }
        if (HelpDeskMaintenanceServerPlugin.LOGGER.isDebug()) {
            for (String newU : this.newNames) {
                HelpDeskMaintenanceServerPlugin.LOGGER.debug((Object)("NEW -" + newU + "-"));
            }
        }
        if (this.newNames.size() - this.problemCount < 1) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.error.nousers", new Object[0]));
        }
        LoginModificationResultResponseData result = new LoginModificationResultResponseData();
        ArrayList<String> resultData = new ArrayList<String>();
        resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg(msgKey, new Object[]{this.newNames.size() - this.problemCount, this.newDomainDisplay}));
        resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.affected.execution.count", new Object[]{this.activeUsers, this.inactiveUsers}));
        if (this.problemCount > 0) {
            resultData.add(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.problem.execution.count", new Object[]{this.problemCount}));
        }
        result.setResult(resultData);
        return result;
    }

    public static String normalize(String userName) {
        return userName.toUpperCase().replace('/', '\\');
    }
}

