/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.dbmigration.handler;

import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.data.MigrateDbSettings;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.data.ValidateDbSettingsResponseData;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.handler.ValidateDBSettingsHandler;
import com.inet.helpdesk.plugins.maintenance.server.dbmigration.runner.DbMigrationRunner;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.maintenance.api.MaintenanceHelper;

public class StartDbMigrationHandler
extends MaintenanceHandler<MigrateDbSettings, ValidateDbSettingsResponseData> {
    public String getMethodName() {
        return "maintenance_dbmigration_startdbmigration";
    }

    public ValidateDbSettingsResponseData invoke(MigrateDbSettings input) throws ClientMessageException {
        ValidateDbSettingsResponseData result = new ValidateDBSettingsHandler().invoke(input);
        String dbConfigValue = MaintenanceHelper.getCurrentConfiguration().get(HDConfigKeys.DB_CONFIGS.getKey(), HDConfigKeys.DB_CONFIGS.getDefault());
        DatabaseConfigInfoList dbConfigs = (DatabaseConfigInfoList)new Json().fromJson(dbConfigValue, DatabaseConfigInfoList.class);
        DatabaseConfigInfo sourceInfo = dbConfigs.get("HDS");
        DatabaseConfigInfo targetInfo = ValidateDBSettingsHandler.convertInput(input);
        String systemuser = null;
        String systempassword = null;
        if ("new".equals(input.getUseraction())) {
            systemuser = input.getSystemuser();
            systempassword = input.getSystempassword();
        }
        DbMigrationRunner.getInstance().startMigration(sourceInfo, targetInfo, systemuser, systempassword, input);
        return result;
    }
}

