/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare;

import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries.UserPreviewEntry;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UnreferencedUsersDataCareTask
implements DataCareTask {
    private static final String KEY = "datacare.unreferencedusers";

    @Nonnull
    public String getExtensionName() {
        return KEY;
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.unreferencedusers.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.unreferencedusers.description", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        MaintenanceConnector connector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        MaintenanceConnector.EntriesToDelete unrelatedUsers = connector.findUnrelatedUsers();
        ArrayList<UserPreviewEntry> list = new ArrayList<UserPreviewEntry>();
        for (MaintenanceConnector.UnrelatedUser user : unrelatedUsers.getExemplaryEntries()) {
            list.add(new UserPreviewEntry().from(user));
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = unrelatedUsers.getFoundEntriesCount();
        preview.setPreviewMsg(HelpDeskMaintenanceServerPlugin.MSG.getMsg(entriesCount > 0 ? "dataCare.unreferencedusers.preview" : "dataCare.unreferencedusers.nopreview", new Object[]{entriesCount, unrelatedUsers.isFoundMore() ? 1 : 0}));
        preview.setExamples(list);
        return preview;
    }

    @Override
    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        MaintenanceConnector connector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        connector.deleteUnrelatedUsers();
        return null;
    }
}

