/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.backup.tasks;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.lib.json.Json;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;

public class TriggersBackupTask
implements BackupTask {
    private String detailTriggers;

    public String getKey() {
        return "helpdesk.triggers";
    }

    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.triggers.title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.triggers.description", new Object[0]);
    }

    public URL getIconURL() {
        return TriggersBackupTask.class.getResource("/com/inet/helpdesk/plugins/maintenance/server/images/jscript_trigger_32.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        ArrayList triggers = (ArrayList)HDConfigKeys.JAVASCRIPT_TRIGGERS.getCurrent();
        try (FileOutputStream out = new FileOutputStream(taskPath.resolve("triggers.zip").toFile());
             ZipOutputStream zip = new ZipOutputStream(out);){
            int count = 0;
            for (HashMap trigger : triggers) {
                String name = (String)trigger.get("name");
                if (name == null) continue;
                try {
                    ZipEntry zipEntry = new ZipEntry(name);
                    zip.putNextEntry(zipEntry);
                    new Json().toJson((Object)trigger, (OutputStream)zip);
                }
                finally {
                    zip.closeEntry();
                }
                ++count;
            }
            this.detailTriggers = HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.triggers.taskdetail", new Object[]{count});
        }
        this.setDetails(contentInformation);
        progressUpdater.updateProgress(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        ArrayList<HashMap> triggers = new ArrayList<HashMap>();
        try (FileInputStream in = new FileInputStream(taskPath.resolve("triggers.zip").toFile());
             ZipInputStream zip = new ZipInputStream(in);){
            while (zip.getNextEntry() != null) {
                try {
                    HashMap trigger = (HashMap)new Json().fromJson((InputStream)zip, HashMap.class);
                    if (trigger == null) continue;
                    triggers.add(trigger);
                }
                finally {
                    zip.closeEntry();
                }
            }
        }
        Configuration config = ConfigurationManager.getInstance().getCurrent();
        config.put(HDConfigKeys.JAVASCRIPT_TRIGGERS.getKey(), new Json().toJson(triggers));
        progressUpdater.updateProgress(100);
    }

    private void setDetails(BackupContentInformation contentInformation) {
        ArrayList<String> details = new ArrayList<String>();
        if (this.detailTriggers != null) {
            details.add(this.detailTriggers);
        }
        contentInformation.putTaskDetails(this.getKey(), details);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

