/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.loginmodification.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.api.LoginModificationTask;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.api.LoginModificationTaskParameter;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationInitResponseData;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationTaskDefinition;
import com.inet.helpdesk.usersandgroups.UserIterator;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoginModificationInitHandler
extends MaintenanceHandler<Void, LoginModificationInitResponseData> {
    private Map<String, DomainData> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginModificationInitResponseData invoke(Void input) throws ClientMessageException {
        LoginModificationInitResponseData lmird;
        HelpDeskMaintenanceServerPlugin.LOGGER.debug((Object)"LoginModificationInitHandler invoke called");
        LoginModificationInitHandler loginModificationInitHandler = this;
        synchronized (loginModificationInitHandler) {
            this.initResponseData();
            new UserIterator().getUserSystemLogins(UserManager.getInstance()).stream().forEach(accountLogins -> this.analyseData((UserIterator.AccountLogins)accountLogins));
            lmird = this.createResponseData(ServerPluginManager.getInstance());
        }
        return lmird;
    }

    public String getMethodName() {
        return "maintenance_loginmodification_init";
    }

    protected void analyseData(UserIterator.AccountLogins accountLogins) {
        for (UserIterator.LoginData systemLogin : accountLogins.getSystemLogins()) {
            if (systemLogin.getDomain() == null) continue;
            DomainData dd = this.cache.get(systemLogin.getDomain());
            if (dd == null) {
                dd = new DomainData(systemLogin.getOriginalDomain());
                this.cache.put(systemLogin.getDomain(), dd);
            }
            dd.handleAccount(accountLogins.getUserAccount());
        }
    }

    protected void initResponseData() {
        this.cache = new HashMap<String, DomainData>();
    }

    protected LoginModificationInitResponseData createResponseData(ServerPluginManager spm) {
        HelpDeskMaintenanceServerPlugin.LOGGER.debug((Object)"createResponseData called");
        LocalizedKey paramKey = new LocalizedKey("existingDomain", HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.entry.name", new Object[0]));
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        Set<String> keys = this.cache.keySet();
        for (String key : keys) {
            DomainData dd = this.cache.get(key);
            values.add(new LocalizedKey(dd.name.toUpperCase(), HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.entry.name.count", new Object[]{dd.name, dd.loginCount})));
            HelpDeskMaintenanceServerPlugin.LOGGER.info((Object)("Domain: " + dd.name + " logins: " + dd.loginCount + " active users: " + dd.activeUsers.size() + " inactive users: " + dd.inactiveUsers.size()));
        }
        this.cache = null;
        Collections.sort(values, new Comparator<LocalizedKey>(){

            @Override
            public int compare(LocalizedKey o1, LocalizedKey o2) {
                return o1.getKey().toUpperCase().compareToIgnoreCase(o2.getKey().toUpperCase());
            }
        });
        LoginModificationTaskParameter param = new LoginModificationTaskParameter(paramKey, values);
        LoginModificationInitResponseData response = new LoginModificationInitResponseData();
        List taskList = spm.get(LoginModificationTask.class);
        ArrayList<LoginModificationTaskDefinition> taskDefs = new ArrayList<LoginModificationTaskDefinition>();
        Collections.sort(taskList, new Comparator<LoginModificationTask>(){

            @Override
            public int compare(LoginModificationTask o1, LoginModificationTask o2) {
                int diff = o1.getPriority() - o2.getPriority();
                if (diff == 0) {
                    return o1.getTitle().compareToIgnoreCase(o2.getTitle());
                }
                return diff;
            }
        });
        for (LoginModificationTask task : taskList) {
            LoginModificationTaskDefinition taskDef = new LoginModificationTaskDefinition();
            taskDef.setKey(task.getKey());
            taskDef.setTitle(task.getTitle());
            taskDef.setDescription(task.getDescription());
            taskDef.setParameter(param);
            taskDefs.add(taskDef);
        }
        response.setTasks(taskDefs);
        return response;
    }

    private class DomainData {
        private String name;
        private int loginCount;
        private Set<GUID> inactiveUsers = new HashSet<GUID>();
        private Set<GUID> activeUsers = new HashSet<GUID>();

        private DomainData(String name) {
            this.name = name;
        }

        private void handleAccount(UserAccount userAccount) {
            ++this.loginCount;
            if (userAccount.isActive()) {
                this.activeUsers.add(userAccount.getID());
            } else {
                this.inactiveUsers.add(userAccount.getID());
            }
        }
    }
}

