/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.backup.tasks;

import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class ClientBackupTask
implements BackupTask {
    public String getKey() {
        return "helpdesk.client";
    }

    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.client.title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.client.description", new Object[0]);
    }

    public URL getIconURL() {
        return ClientBackupTask.class.getResource("/com/inet/helpdesk/plugins/maintenance/server/images/client_directory_32.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        helper.createZipFromFolderContent(persistence.resolve("Client"), taskPath.resolve("client.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                final String clientDetail = HelpDeskMaintenanceServerPlugin.MSG.getMsg("backup.task.client.taskdetail", new Object[]{files});
                contentInformation.putTaskDetails(ClientBackupTask.this.getKey(), (ArrayList)new ArrayList<String>(){
                    {
                        this.add(clientDetail);
                    }
                });
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, final ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        Path source = taskPath.resolve("client.zip");
        PersistenceEntry target = persistence.resolve("Client");
        helper.extractZipIntoFolder(source, target, false, new FileProgress(){

            public void progressUpdate(int progress, int files) {
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

