/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.CompositePrivateKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.ExtendedContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.TeeOutputStream;

public class JcaContentSignerBuilder {
    private static final Set isAlgIdFromPrivate = new HashSet();
    private static final DefaultSignatureAlgorithmIdentifierFinder SIGNATURE_ALGORITHM_IDENTIFIER_FINDER = new DefaultSignatureAlgorithmIdentifierFinder();
    private static Map<Object, ASN1ObjectIdentifier> lmsSigOids;
    private final String signatureAlgorithm;
    private final AlgorithmIdentifier signatureDigestAlgorithm;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmParameterSpec sigAlgSpec;

    public JcaContentSignerBuilder(String string) {
        this(string, (AlgorithmIdentifier)null);
    }

    private static AlgorithmIdentifier getSigDigAlgId(PublicKey publicKey) {
        byte[] byArray = publicKey.getEncoded();
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)byArray);
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getOctets();
            int n = Pack.bigEndianToInt((byte[])byArray2, (int)4);
            return new AlgorithmIdentifier(lmsSigOids.get(n));
        }
        return null;
    }

    public JcaContentSignerBuilder(String string, PublicKey publicKey) {
        this(string, JcaContentSignerBuilder.getSigDigAlgId(publicKey));
    }

    public JcaContentSignerBuilder(String string, AlgorithmIdentifier algorithmIdentifier) {
        this.signatureAlgorithm = string;
        this.signatureDigestAlgorithm = algorithmIdentifier;
    }

    public JcaContentSignerBuilder(String string, AlgorithmParameterSpec algorithmParameterSpec) {
        this(string, algorithmParameterSpec, null);
    }

    public JcaContentSignerBuilder(String string, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier) {
        this.signatureAlgorithm = string;
        this.signatureDigestAlgorithm = algorithmIdentifier;
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new IllegalArgumentException("unknown sigParamSpec: " + (algorithmParameterSpec == null ? "null" : algorithmParameterSpec.getClass().getName()));
        }
        PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
        this.sigAlgSpec = pSSParameterSpec;
        this.sigAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)JcaContentSignerBuilder.createPSSParams(pSSParameterSpec));
    }

    public JcaContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentSignerBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public JcaContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        try {
            if (this.sigAlgSpec == null) {
                this.sigAlgId = this.getSigAlgId(privateKey);
            }
            final AlgorithmIdentifier algorithmIdentifier = this.sigAlgId;
            final Signature signature = this.helper.createSignature(this.sigAlgId);
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
            final ContentSigner contentSigner = new ContentSigner(){
                private OutputStream stream;
                {
                    this.stream = OutputStreamFactory.createStream((Signature)signature);
                }

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }

                @Override
                public OutputStream getOutputStream() {
                    return this.stream;
                }

                @Override
                public byte[] getSignature() {
                    try {
                        return signature.sign();
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
            if (this.signatureDigestAlgorithm != null) {
                return new ExtendedContentSigner(){
                    private final AlgorithmIdentifier digestAlgorithm;
                    private final ContentSigner signer;
                    {
                        this.digestAlgorithm = JcaContentSignerBuilder.this.signatureDigestAlgorithm;
                        this.signer = contentSigner;
                    }

                    @Override
                    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                        return this.digestAlgorithm;
                    }

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return this.signer.getAlgorithmIdentifier();
                    }

                    @Override
                    public OutputStream getOutputStream() {
                        return this.signer.getOutputStream();
                    }

                    @Override
                    public byte[] getSignature() {
                        return this.signer.getSignature();
                    }
                };
            }
            return contentSigner;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private AlgorithmIdentifier getSigAlgId(PrivateKey privateKey) {
        if (isAlgIdFromPrivate.contains(Strings.toUpperCase((String)this.signatureAlgorithm))) {
            AlgorithmIdentifier algorithmIdentifier = SIGNATURE_ALGORITHM_IDENTIFIER_FINDER.find(privateKey.getAlgorithm());
            if (algorithmIdentifier == null) {
                return PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()).getPrivateKeyAlgorithm();
            }
            return algorithmIdentifier;
        }
        return SIGNATURE_ALGORITHM_IDENTIFIER_FINDER.find(this.signatureAlgorithm);
    }

    private ContentSigner buildComposite(CompositePrivateKey compositePrivateKey) throws OperatorCreationException {
        try {
            List list = compositePrivateKey.getPrivateKeys();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)this.sigAlgId.getParameters());
            final Signature[] signatureArray = new Signature[aSN1Sequence.size()];
            for (int i = 0; i != aSN1Sequence.size(); ++i) {
                signatureArray[i] = this.helper.createSignature(AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(i)));
                if (this.random != null) {
                    signatureArray[i].initSign((PrivateKey)list.get(i), this.random);
                    continue;
                }
                signatureArray[i].initSign((PrivateKey)list.get(i));
            }
            OutputStream outputStream = OutputStreamFactory.createStream((Signature)signatureArray[0]);
            for (int i = 1; i != signatureArray.length; ++i) {
                outputStream = new TeeOutputStream(outputStream, OutputStreamFactory.createStream((Signature)signatureArray[i]));
            }
            final OutputStream outputStream2 = outputStream;
            return new ContentSigner(){
                OutputStream stream;
                {
                    this.stream = outputStream2;
                }

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return JcaContentSignerBuilder.this.sigAlgId;
                }

                @Override
                public OutputStream getOutputStream() {
                    return this.stream;
                }

                @Override
                public byte[] getSignature() {
                    try {
                        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                        for (int i = 0; i != signatureArray.length; ++i) {
                            aSN1EncodableVector.add((ASN1Encodable)new DERBitString(signatureArray[i].sign()));
                        }
                        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new RuntimeOperatorException("exception encoding signature: " + iOException.getMessage(), iOException);
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private static RSASSAPSSparams createPSSParams(PSSParameterSpec pSSParameterSpec) {
        AlgorithmIdentifier algorithmIdentifier;
        DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier algorithmIdentifier2 = defaultDigestAlgorithmIdentifierFinder.find(pSSParameterSpec.getDigestAlgorithm());
        if (algorithmIdentifier2.getParameters() == null) {
            algorithmIdentifier2 = new AlgorithmIdentifier(algorithmIdentifier2.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ((algorithmIdentifier = defaultDigestAlgorithmIdentifierFinder.find(((MGF1ParameterSpec)pSSParameterSpec.getMGFParameters()).getDigestAlgorithm())).getParameters() == null) {
            algorithmIdentifier = new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
        }
        return new RSASSAPSSparams(algorithmIdentifier2, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier), new ASN1Integer((long)pSSParameterSpec.getSaltLength()), new ASN1Integer((long)pSSParameterSpec.getTrailerField()));
    }

    static {
        isAlgIdFromPrivate.add("DILITHIUM");
        isAlgIdFromPrivate.add("SPHINCS+");
        isAlgIdFromPrivate.add("SPHINCSPlus");
        isAlgIdFromPrivate.add("ML-DSA");
        isAlgIdFromPrivate.add("SLH-DSA");
        isAlgIdFromPrivate.add("HASH-ML-DSA");
        isAlgIdFromPrivate.add("HASH-SLH-DSA");
        lmsSigOids = new HashMap<Object, ASN1ObjectIdentifier>(){
            {
                this.put(5, NISTObjectIdentifiers.id_sha256);
                this.put(6, NISTObjectIdentifiers.id_sha256);
                this.put(7, NISTObjectIdentifiers.id_sha256);
                this.put(8, NISTObjectIdentifiers.id_sha256);
                this.put(9, NISTObjectIdentifiers.id_sha256);
                this.put(10, NISTObjectIdentifiers.id_sha256);
                this.put(11, NISTObjectIdentifiers.id_sha256);
                this.put(12, NISTObjectIdentifiers.id_sha256);
                this.put(13, NISTObjectIdentifiers.id_sha256);
                this.put(14, NISTObjectIdentifiers.id_sha256);
                this.put(15, NISTObjectIdentifiers.id_shake256_len);
                this.put(16, NISTObjectIdentifiers.id_shake256_len);
                this.put(17, NISTObjectIdentifiers.id_shake256_len);
                this.put(18, NISTObjectIdentifiers.id_shake256_len);
                this.put(19, NISTObjectIdentifiers.id_shake256_len);
                this.put(20, NISTObjectIdentifiers.id_shake256_len);
                this.put(21, NISTObjectIdentifiers.id_shake256_len);
                this.put(22, NISTObjectIdentifiers.id_shake256_len);
                this.put(23, NISTObjectIdentifiers.id_shake256_len);
                this.put(24, NISTObjectIdentifiers.id_shake256_len);
            }
        };
    }
}

