/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.KemEncapsulationLengthProvider;
import org.bouncycastle.operator.NISTObjectIdentifiers;
import org.bouncycastle.util.Integers;

public class DefaultKemEncapsulationLengthProvider
implements KemEncapsulationLengthProvider {
    private static Map<ASN1ObjectIdentifier, Integer> kemEncapsulationLengths = new HashMap<ASN1ObjectIdentifier, Integer>();

    @Override
    public int getEncapsulationLength(AlgorithmIdentifier algorithmIdentifier) {
        return kemEncapsulationLengths.get(algorithmIdentifier.getAlgorithm());
    }

    static {
        kemEncapsulationLengths.put(NISTObjectIdentifiers.id_alg_ml_kem_512, Integers.valueOf((int)768));
        kemEncapsulationLengths.put(NISTObjectIdentifiers.id_alg_ml_kem_768, Integers.valueOf((int)1088));
        kemEncapsulationLengths.put(NISTObjectIdentifiers.id_alg_ml_kem_1024, Integers.valueOf((int)1568));
    }
}

