/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.api.profiles;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailEncryption;
import com.inet.mail.api.profiles.a;
import com.inet.mail.api.profiles.b;
import com.inet.mail.api.profiles.c;
import com.inet.mail.api.profiles.d;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class MailProfile {
    public static final boolean XOAUTH2 = ServerPluginManager.getInstance().isPluginLoaded("oauth.connection");
    static final ConfigValue<String> ak = new ConfigValue(com.inet.mail.structure.a.aL);
    private static final Map<@Nonnull String, @Nonnull MailProfile> al = MailProfile.f();

    @Nonnull
    private static @Nonnull Map<@Nonnull String, @Nonnull MailProfile> f() {
        List<@Nonnull MailProfile> list = Arrays.asList(new a(), new b(), new d(), new c());
        Map<@Nonnull String, @Nonnull MailProfile> map = list.stream().collect(Collectors.toMap(MailProfile::getName, mailProfile -> mailProfile));
        return Collections.unmodifiableMap(map);
    }

    @Nullable
    public static MailProfile getProfile() {
        return MailProfile.getProfile((String)ak.get());
    }

    @Nullable
    public static MailProfile getProfile(String provider) {
        return al.get(provider);
    }

    @Nonnull
    public static List<MailProfile> getAvailableProfiles() {
        ArrayList<MailProfile> arrayList = new ArrayList<MailProfile>();
        if (XOAUTH2) {
            for (String string : OauthAccessTokenManager.getConfiguredProviderIDs()) {
                for (MailProfile mailProfile : al.values()) {
                    if (!Objects.equals(mailProfile.getOauthProvider(), string)) continue;
                    arrayList.add(mailProfile);
                }
            }
        }
        return arrayList;
    }

    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract String getDisplayName();

    @Nonnull
    public String getOauthProvider() {
        return this.getName();
    }

    @Nonnull
    public abstract String getSmtpHost();

    @Nonnull
    public String getSmtpPort() {
        return "587";
    }

    @Nonnull
    public abstract String getSmtpScopes();

    @Nonnull
    public MailEncryption getSmtpEncryption() {
        return MailEncryption.STARTTLS;
    }

    @Nonnull
    public abstract String getImapHost();

    @Nonnull
    public String getImapPort() {
        return "993";
    }

    @Nonnull
    public MailEncryption getImapEncryption() {
        return MailEncryption.SSL;
    }

    @Nonnull
    public abstract String getImapScopes();

    @Nonnull
    public MailAuthenticationMethod getAuthenticationMethod() {
        return MailAuthenticationMethod.XOAUTH2;
    }
}

