/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.api;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.mail.api.BaseEmail;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.mail.internet.InternetAddress;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

@InternalApi
public class EmailAddressUtils
implements EmailAddressHelper {
    public boolean isAvailable(@Nonnull GUID accountID) {
        if (!BaseEmail.isSmtpConfigured()) {
            return false;
        }
        if (BaseEmail.PROPERTY_SENDER.get() == null) {
            return false;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(accountID);
        String string = (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
        return this.getValidEmailAddressesFrom(string).size() > 0;
    }

    public boolean testEmailAddressString(String in) {
        return this.getEmailAddress(in, exception -> {}) != null;
    }

    public void validateSingleAddress(String in) throws Exception {
        this.getEmailAddress(in, exception -> ErrorCode.throwAny((Throwable)exception));
    }

    public InternetAddress getEmailAddress(String addr, Consumer<Exception> exceptionConsumer) {
        InternetAddress internetAddress;
        block6: {
            internetAddress = null;
            if (addr != null) {
                try {
                    addr = addr.replace('\u00a0', ' ');
                    int n = addr.lastIndexOf(60);
                    int n2 = addr.lastIndexOf(62);
                    if (n > -1) {
                        addr = n2 > n ? addr.substring(n + 1, n2) : addr.substring(n + 1);
                    } else if (n2 > -1) {
                        addr = addr.substring(0, n2);
                    }
                    addr = addr.trim();
                    internetAddress = new InternetAddress(addr, true);
                }
                catch (Exception exception) {
                    if (exceptionConsumer == null) break block6;
                    exceptionConsumer.accept(exception);
                }
            }
        }
        return internetAddress;
    }
}

