/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.api;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailEncryption;
import com.inet.mail.api.MailServerProbeResult;
import com.inet.mail.api.profiles.MailProfile;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ApplicationDescription;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.annotation.Nonnull;

@InternalApi
public class MailServerProbe
extends BaseEmail {
    private String D;
    private int E;
    private MailAuthenticationMethod F;
    private String G;
    private String H;
    private String I;
    private int J;
    private MailEncryption K = MailEncryption.NONE;
    private String L;
    private String M;
    private String N;
    private String O;
    private String P;
    private String Q;

    @Deprecated
    public MailServerProbe() {
        LogManager.deprecatedMessage();
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        this.M = "Validation email from " + applicationDescription.getApplicationName();
        this.N = "This is a test email from " + applicationDescription.getApplicationName() + ".";
    }

    public MailServerProbe(String subject, String message) {
        this.M = subject;
        this.N = message;
    }

    public MailServerProbe setSmtpHost(String smtpHost) {
        this.D = smtpHost;
        return this;
    }

    public MailServerProbe setSmtpPort(int smtpPort) {
        this.E = smtpPort;
        return this;
    }

    public MailServerProbe setSender(String address) {
        this.O = address;
        return this;
    }

    public MailServerProbe setAuthenticationMethod(MailAuthenticationMethod authenticationMethod) {
        this.F = authenticationMethod;
        return this;
    }

    public MailServerProbe setUser(String user) {
        this.G = user;
        return this;
    }

    public MailServerProbe setPassword(String password) {
        this.H = password;
        return this;
    }

    public MailServerProbe setPop3Host(String pop3Host) {
        this.I = pop3Host;
        return this;
    }

    public MailServerProbe setPop3Port(int pop3Port) {
        this.J = pop3Port;
        return this;
    }

    public MailServerProbe setEncryption(MailEncryption encryption) {
        this.K = encryption;
        return this;
    }

    public MailServerProbe setEmailRecipient(String email) {
        this.L = email;
        return this;
    }

    public MailServerProbe setSmtpProvider(String provider) {
        this.P = provider;
        return this;
    }

    public MailServerProbe setSmtpRefreshToken(String refreshToken) {
        this.Q = refreshToken;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailServerProbeResult probe() {
        Object object;
        Object object2;
        ClassLoader classLoader;
        Thread thread;
        block45: {
            ClassLoader classLoader2 = Session.class.getClassLoader();
            thread = Thread.currentThread();
            classLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(classLoader2);
            }
            catch (SecurityException securityException) {
                if (!LOGGER.isError()) break block45;
                LOGGER.error((Throwable)securityException);
            }
        }
        try {
            String string2;
            Object object3;
            String string3;
            MailEncryption mailEncryption;
            MailAuthenticationMethod mailAuthenticationMethod;
            String string4;
            String string5;
            InternetAddress internetAddress;
            if (this.O != null) {
                internetAddress = new InternetAddress(this.O);
            } else {
                object2 = this.getTo();
                if (object2 == null || ((InternetAddress[])object2).length == 0) {
                    MailServerProbeResult mailServerProbeResult = new MailServerProbeResult(MailServerProbeResult.Status.INVALID_SENDER, "Sender is empty.");
                    return mailServerProbeResult;
                }
                internetAddress = object2[0];
            }
            MailProfile mailProfile = MailProfile.getProfile(this.P);
            if (mailProfile != null) {
                object2 = mailProfile.getSmtpHost();
                object = mailProfile.getSmtpPort();
                string5 = null;
                string4 = null;
                mailAuthenticationMethod = mailProfile.getAuthenticationMethod();
                this.K = mailEncryption = mailProfile.getSmtpEncryption();
                string3 = internetAddress != null ? internetAddress.getAddress() : null;
                object3 = string -> {};
                string2 = OauthAccessTokenManager.getAccessToken((String)mailProfile.getOauthProvider(), (String)this.Q, object3);
            } else {
                object2 = this.D;
                object = Integer.toString(this.E);
                string5 = this.I;
                string4 = Integer.toString(this.J);
                mailAuthenticationMethod = this.F;
                mailEncryption = this.K;
                string3 = this.G;
                string2 = this.H;
            }
            if (object2 == null || ((String)object2).isEmpty()) {
                object3 = new MailServerProbeResult(MailServerProbeResult.Status.UNKNOWN_HOST_SMTP, "SMTP host not set");
                return object3;
            }
            object3 = this.send((String)object2, (String)object, string5, string4, mailAuthenticationMethod, mailEncryption, string3, string2, internetAddress);
            if (object3 instanceof MailServerProbeResult) {
                MailServerProbeResult mailServerProbeResult = (MailServerProbeResult)object3;
                return mailServerProbeResult;
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("Mail probe failure: " + String.valueOf((Object)noSuchProviderException)));
            }
            object2 = new MailServerProbeResult(MailServerProbeResult.Status.INTERNAL_FAILURE, StringFunctions.getUserFriendlyErrorMessage((Throwable)noSuchProviderException));
            return object2;
        }
        catch (MessagingException messagingException) {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("Mail probe failure: " + String.valueOf((Object)messagingException)));
            }
            try {
                InetAddress.getByName(this.D);
                object2 = StringFunctions.getUserFriendlyErrorMessage((Throwable)messagingException);
                if (((String)object2).length() > 200) {
                    object2 = ((String)object2).substring(0, 197) + "...";
                }
                object = new MailServerProbeResult(MailServerProbeResult.Status.LOGIN_FAILURE_SMTP, (String)object2);
                return object;
            }
            catch (UnknownHostException unknownHostException) {
                object = new MailServerProbeResult(MailServerProbeResult.Status.UNKNOWN_HOST_SMTP, StringFunctions.getUserFriendlyErrorMessage((Throwable)unknownHostException));
                return object;
            }
        }
        catch (Throwable throwable) {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("Mail probe failure: " + String.valueOf(throwable)));
            }
            object2 = new MailServerProbeResult(MailServerProbeResult.Status.INTERNAL_FAILURE, StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
            return object2;
        }
        finally {
            block47: {
                try {
                    thread.setContextClassLoader(classLoader);
                }
                catch (SecurityException securityException) {
                    if (!LOGGER.isError()) break block47;
                    LOGGER.error((Throwable)securityException);
                }
            }
        }
        return new MailServerProbeResult(MailServerProbeResult.Status.OK);
    }

    @Override
    protected Object authenticationFailedHook(AuthenticationFailedException afe, Transport transport, Session session, Properties props) throws AuthenticationFailedException {
        if (this.K == MailEncryption.NONE) {
            try {
                transport.close();
                props.put("mail.smtp.starttls.enable", "true");
                session = Session.getInstance((Properties)props, null);
                transport = session.getTransport("smtp");
                transport.connect(this.D, this.E, this.G, this.H);
                return new MailServerProbeResult(MailServerProbeResult.Status.STARTTLS_REQUIRED);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        throw afe;
    }

    @Override
    protected String getSubject() {
        return this.M;
    }

    @Override
    protected InternetAddress[] getTo() {
        return MailServerProbe.getAddresses(this.L, this.getLogger());
    }

    @Override
    protected String getMessage() {
        return this.N;
    }

    @Override
    @Nonnull
    protected Logger getLogger() {
        return LogManager.getConfigLogger();
    }
}

