/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.smime;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.mail.smime.e;
import com.inet.notification.Notification;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.notification.TimedGenerator;
import com.inet.notification.Times;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class SMimeExpiredNotificationGenerator
extends PermissionNotificationGenerator
implements TimedGenerator {
    @Nonnull
    static final GUID ID = GUID.valueOf((String)"e0k03pzrj8z1bfmc6vxc14jlq");
    private String address;
    private long expired;
    private long[] times;

    SMimeExpiredNotificationGenerator(String address, long expired) {
        this.address = address;
        this.expired = expired;
        this.times = new long[5];
        long[] lArray = this.times;
        lArray[0] = expired - 1209600000L;
        lArray[1] = expired - 259200000L;
        lArray[2] = expired - 172800000L;
        lArray[3] = expired - 86400000L;
        lArray[4] = expired + 2592000000L;
    }

    @Nonnull
    public GUID getId() {
        return ID;
    }

    @Nonnull
    public Notification createNotification() {
        int n = (int)((this.expired - System.currentTimeMillis()) / 86400000L);
        Notification notification = new Notification(e.MSG.getMsg("category.smime", new Object[0]), e.MSG.getMsg("certificate.willexpired", new Object[]{this.address, n}));
        notification.setTargetUrl("configmanager/dialog/category.smime");
        if (n <= 3) {
            notification.setCritical(true);
        }
        return notification;
    }

    @Nullable
    public Times getNextTimes() {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        for (long l3 : this.times) {
            if (l3 <= l) continue;
            l2 = l3;
            break;
        }
        return new Times(this.times[0], l2);
    }
}

