/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.utils;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.plugins.livesupport.structure.LiveSupportThemeStructureProvider;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.theme.server.LessGenerator;
import com.inet.theme.server.ThemeResource;
import com.inet.theme.server.ThemeService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class LiveSupportThemeService
extends ThemeService {
    private static LiveSupportThemeService instance = null;
    private static Map<String, String> DEFAULT_COLORS = null;
    public static final String APP_KEY = "LiveSupportThemeService";
    private static final String LIVE_SUPPORT_BASIC_COLORS = "/com/inet/helpdesk/plugins/livesupport/client/styles/livesupport.basic.less";
    private static String COLOR_MAP_JSON = null;
    private static ConfigValue<String> THEME_COLORS = new ConfigValue<String>(LiveSupportThemeStructureProvider.LIVE_SUPPORT_THEMECOLORS){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            COLOR_MAP_JSON = null;
        }
    };

    protected LiveSupportThemeService() {
        super(APP_KEY, false);
    }

    public static synchronized LiveSupportThemeService getInstance() {
        if (instance == null) {
            instance = new LiveSupportThemeService();
        }
        return instance;
    }

    public static void registerExtension(ServerPluginManager spm) {
        spm.register(ThemeResource.class, (Object)new ThemeResource(APP_KEY, LiveSupportThemeService.class.getResource(LIVE_SUPPORT_BASIC_COLORS)));
        spm.register(ThemeResource.class, (Object)new ThemeResource(APP_KEY, LiveSupportThemeService.class.getResource("/com/inet/helpdesk/plugins/livesupport/client/styles/livesupport.less")));
    }

    public boolean doServeCorporateTheme(HttpServletRequest request, HttpServletResponse response) {
        HttpServletRequestWrapper servletRequest = new HttpServletRequestWrapper(request){

            public String getParameter(@Nullable String name) {
                if ("themecolors".equals(name)) {
                    if (COLOR_MAP_JSON == null) {
                        HashMap<String, String> defaultColors = LiveSupportThemeService.this.getDefaultColors();
                        TreeMap<String, String> colorMap = new TreeMap<String, String>(defaultColors);
                        if (((String)THEME_COLORS.get()).length() > 0) {
                            HashMap colorJsonMap = (HashMap)new Json().fromJson((String)THEME_COLORS.get(), HashMap.class);
                            Objects.requireNonNull(colorJsonMap);
                            for (Map.Entry entry : colorJsonMap.entrySet()) {
                                Object value = (String)entry.getValue();
                                if (((String)entry.getKey()).endsWith("size") && !((String)value).endsWith("px")) {
                                    value = (String)value + "px";
                                }
                                colorMap.put((String)entry.getKey(), (String)value);
                            }
                        }
                        COLOR_MAP_JSON = new Json().toJson(colorMap);
                    }
                    return COLOR_MAP_JSON;
                }
                return super.getParameter(name);
            }
        };
        ThemeService.THEMESERVEDSTATE result = super.serveCorporateTheme((HttpServletRequest)servletRequest, response);
        return !result.equals((Object)ThemeService.THEMESERVEDSTATE.error) && !result.equals((Object)ThemeService.THEMESERVEDSTATE.notheme);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The URL uses an internal resource only and does not use any user generated input")
    public HashMap<String, String> getDefaultColors() {
        if (DEFAULT_COLORS == null) {
            try {
                URL url = LiveSupportThemeService.class.getResource(LIVE_SUPPORT_BASIC_COLORS);
                Objects.requireNonNull(url);
                URLConnection openConnection = url.openConnection();
                InputStream is = openConnection.getInputStream();
                String data = new String(LessGenerator.getDataFromInputStream((InputStream)is));
                String[] lines = data.split("\r?\n");
                HashMap<String, String> map = new HashMap<String, String>();
                for (String line : lines) {
                    if (line.length() <= 0 || line.indexOf(58) <= 0 || line.indexOf(59) <= 0 || !line.startsWith("@")) continue;
                    if ((line = line.trim()).endsWith(";")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    int index = line.indexOf(58);
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    map.put(key, value);
                }
                DEFAULT_COLORS = Collections.unmodifiableMap(map);
            }
            catch (Throwable e) {
                LiveSupportServerPlugin.LOGGER.error(e);
                return new HashMap<String, String>();
            }
        }
        return new HashMap<String, String>(DEFAULT_COLORS);
    }
}

