/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.structure;

import com.inet.config.ConfigKey;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LiveSupportStructureProvider
extends AbstractStructureProvider {
    private static final int SIZE_2MB = 0x200000;
    private static final int SIZE_5MB = 0x500000;
    private static final int SIZE_10MB = 0xA00000;
    private static final int SIZE_20MB = 0x1400000;
    public static final String CATEGORY_LIVE_SUPPORT = "category.livesupport";
    private static final String GROUP_LIVE_SUPPORT = "group.livesupport";
    public static final ConfigKey LIVE_SUPPORT_CAN_BE_PROVIDED = new ConfigKey("livesupport.canbeprovided", "true", Boolean.class);
    public static final ConfigKey LIVE_SUPPORT_USER_NAME_REQUIRED = new ConfigKey("livesupport.requireUserName", VISIBILITY.visible.toString(), VISIBILITY.class);
    public static final ConfigKey LIVE_SUPPORT_EMAIL_REQUIRED = new ConfigKey("livesupport.requireUserEmail", VISIBILITY.visible.toString(), VISIBILITY.class);
    public static final ConfigKey LIVE_SUPPORT_SHOW_TIME = new ConfigKey("livesupport.showTime", "true", Boolean.class);
    public static final ConfigKey LIVE_SUPPORT_DISPATCH_TO = new ConfigKey("livesupport.dispatchTo", null, GUID.class);
    public static final ConfigKey LIVE_SUPPORT_MAX_ATTACHMENT_SIZE = new ConfigKey("livesupport.maxAttachmentSize", "2097152", Long.class);
    private static final Comparator<? super UserGroupInfo> COMPARATOR = (a, b) -> a.getDisplayName().compareTo(b.getDisplayName());

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "ticketsettings": {
                categories.add(new ConfigCategory(200, CATEGORY_LIVE_SUPPORT, this.translate(settings, CATEGORY_LIVE_SUPPORT, new Object[0]), "components-live-support"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.livesupport": {
                return ((Object)((Object)this)).getClass().getResource("livesupport_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.livesupport": {
                configPropertyGroups.add(new ConfigPropertyGroup(100, GROUP_LIVE_SUPPORT));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.livesupport": {
                String resourceValue;
                this.addTo(configProperties, LIVE_SUPPORT_CAN_BE_PROVIDED, settings);
                this.addTo(configProperties, LIVE_SUPPORT_SHOW_TIME, settings);
                ArrayList<LocalizedKey> visibilityOptions = new ArrayList<LocalizedKey>();
                visibilityOptions.add(new LocalizedKey(VISIBILITY.required.toString(), LiveSupportServerPlugin.MSG.getMsg("config.visibility." + VISIBILITY.required.toString(), new Object[0])));
                visibilityOptions.add(new LocalizedKey(VISIBILITY.visible.toString(), LiveSupportServerPlugin.MSG.getMsg("config.visibility." + VISIBILITY.visible.toString(), new Object[0])));
                visibilityOptions.add(new LocalizedKey(VISIBILITY.hidden.toString(), LiveSupportServerPlugin.MSG.getMsg("config.visibility." + VISIBILITY.hidden.toString(), new Object[0])));
                this.addSelectTo(configProperties, LIVE_SUPPORT_USER_NAME_REQUIRED.getKey(), settings.getValue(LIVE_SUPPORT_USER_NAME_REQUIRED), "SimpleText", settings, visibilityOptions);
                this.addSelectTo(configProperties, LIVE_SUPPORT_EMAIL_REQUIRED.getKey(), settings.getValue(LIVE_SUPPORT_EMAIL_REQUIRED), "SimpleText", settings, visibilityOptions);
                Set resources = UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE);
                List parentResources = resources.stream().filter(r -> !r.hasParent()).sorted(COMPARATOR).collect(Collectors.toList());
                ArrayList<LocalizedKey> options = new ArrayList<LocalizedKey>();
                for (UserGroupInfo parent : parentResources) {
                    options.add(new LocalizedKey(parent.getKey(), parent.getDisplayName()));
                    resources.stream().filter(r -> r.hasParent() && parent.getID().equals((Object)r.getParentID())).sorted(COMPARATOR).forEach(r -> options.add(new LocalizedKey(r.getKey(), parent.getDisplayName() + " / " + r.getDisplayName())));
                }
                options.add(0, new LocalizedKey("", LiveSupportServerPlugin.MSG.getMsg("config.doNotDispatch", new Object[0])));
                String testValue = resourceValue = settings.getValue(LIVE_SUPPORT_DISPATCH_TO);
                Optional<LocalizedKey> first = options.stream().filter(o -> o.getKey().equals(testValue)).findFirst();
                if (first.isEmpty()) {
                    resourceValue = "";
                }
                this.addSelectTo(configProperties, LIVE_SUPPORT_DISPATCH_TO.getKey(), resourceValue, "SimpleText", settings, options);
                ArrayList<LocalizedKey> sizes = new ArrayList<LocalizedKey>();
                sizes.add(new LocalizedKey("0", LiveSupportServerPlugin.MSG.getMsg("config.upload.noUpload", new Object[0])));
                sizes.add(new LocalizedKey("2097152", LiveSupportServerPlugin.MSG.getMsg("config.upload.2MB", new Object[0])));
                sizes.add(new LocalizedKey("5242880", LiveSupportServerPlugin.MSG.getMsg("config.upload.5MB", new Object[0])));
                sizes.add(new LocalizedKey("10485760", LiveSupportServerPlugin.MSG.getMsg("config.upload.10MB", new Object[0])));
                sizes.add(new LocalizedKey("20971520", LiveSupportServerPlugin.MSG.getMsg("config.upload.20MB", new Object[0])));
                this.addSelectTo(configProperties, LIVE_SUPPORT_MAX_ATTACHMENT_SIZE.getKey(), settings.getValue(LIVE_SUPPORT_MAX_ATTACHMENT_SIZE), "SimpleText", settings, sizes);
                break;
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
    }

    public static enum VISIBILITY {
        required,
        visible,
        hidden;


        public Character getValue() {
            return Character.valueOf(this.toString().charAt(0));
        }
    }
}

