/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.utils;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacUtils {
    public static String generateHMAC(String message, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] bytes = HmacUtils.hmac("HmacSHA256", key, message.getBytes());
        return new String(Base64.getEncoder().encode(bytes));
    }

    public static boolean verifyHMAC(String signature, String message, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        return signature.equals(HmacUtils.generateHMAC(message, key));
    }

    private static byte[] hmac(String algorithm, byte[] key, byte[] message) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(message);
    }
}

