/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.notifications;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.plugins.livesupport.server.LiveSupportActiveSupporterProvider;
import com.inet.helpdesk.plugins.livesupport.server.ticket.LiveSupportTicketActionExtension;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportCombinedFile;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.notification.Notification;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

@JsonData
public class LiveSupportNotificationGenerator
extends NotificationGenerator {
    private Integer ticketId;

    private LiveSupportNotificationGenerator(Integer ticketId) {
        this.ticketId = ticketId;
    }

    public String getPeriodKey() {
        return null;
    }

    @Nonnull
    public GUID getId() {
        return GUID.generateFor((int)this.ticketId);
    }

    public String getGroupingKey() {
        return "helpdesk.notification.resource";
    }

    public boolean isForCurrentUser() {
        return LiveSupportActiveSupporterProvider.getResponsibleUsersForTicket(this.ticketId).contains(UserManager.getInstance().getCurrentUserAccountID());
    }

    @Nonnull
    public Notification createNotification() {
        String userDisplayName = null;
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(this.ticketId.intValue());
        if (ticket != null) {
            userDisplayName = (String)ticket.getFieldOrAttributeValue(LiveSupportTicketActionExtension.USER_DISPLAY_NAME);
        }
        if (StringFunctions.isEmpty(userDisplayName)) {
            userDisplayName = LiveSupportCombinedFile.CLIENT_MESSAGES.getMsg("ui.anonymous", new Object[0]);
        }
        Notification notification = new Notification(LiveSupportServerPlugin.MSG.getMsg("notification.title", new Object[]{this.ticketId}), LiveSupportServerPlugin.MSG.getMsg("notification.body", new Object[]{userDisplayName}));
        notification.setTargetUrl("ticketlist/ticket/" + this.ticketId);
        return notification;
    }

    public Set<GUID> getTargetUserIds(@Nonnull Set<GUID> preFilteredUserIds) {
        preFilteredUserIds.retainAll(LiveSupportActiveSupporterProvider.getResponsibleUsersForTicket(this.ticketId));
        return preFilteredUserIds;
    }

    public static void createNotification(Integer ticketId) {
        GUID guid = GUID.generateFor((int)ticketId);
        ForkJoinPool.commonPool().execute(() -> {
            NotificationManager.getInstance().unregisterGenerator(guid);
            NotificationManager.getInstance().clearGeneratorState(guid);
            NotificationManager.getInstance().registerGenerator((NotificationGenerator)new LiveSupportNotificationGenerator(ticketId));
        });
    }

    public static void clearNotification(Integer ticketId) {
        GUID guid = GUID.generateFor((int)ticketId);
        ForkJoinPool.commonPool().execute(() -> {
            NotificationManager.getInstance().unregisterGenerator(guid);
            NotificationManager.getInstance().clearGeneratorState(guid);
        });
    }
}

