/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.utils;

import com.inet.classloader.I18nMessages;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.plugins.livesupport.server.session.LiveSupportPreflightSessionCache;
import com.inet.helpdesk.plugins.livesupport.utils.LiveSupportThemeService;
import com.inet.http.servlet.NopHttpServletResponse;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class LiveSupportCombinedFile
extends FileCombiner.CombinedFile {
    public static final I18nMessages CLIENT_MESSAGES = new I18nMessages("com.inet.helpdesk.plugins.livesupport.client.i18n.ClientMessages", LiveSupportCombinedFile.class);
    private static final URL DEFAULT_CSS = LiveSupportCombinedFile.class.getResource("/com/inet/helpdesk/plugins/livesupport/client/styles/livesupport.compiled.css");

    public LiveSupportCombinedFile() {
        super("application/x-javascript; charset=utf-8", new URL[0]);
        this.add(LiveSupportServerPlugin.class, "client/js/i18n.js");
        this.add(LiveSupportServerPlugin.class, "client/js/lib/events.js");
        this.add(LiveSupportServerPlugin.class, "client/js/lib/prototype.array.js");
        this.add(LiveSupportServerPlugin.class, "client/js/lib/prototype.element.js");
        this.add(LiveSupportServerPlugin.class, "client/js/lib/dragging.js");
        this.add(LiveSupportServerPlugin.class, "client/js/connections.js");
        this.add(LiveSupportServerPlugin.class, "client/js/attachments.js");
        this.add(LiveSupportServerPlugin.class, "client/js/lazy-load.js");
        this.add(LiveSupportServerPlugin.class, "client/js/ui-components.js");
        this.add(LiveSupportServerPlugin.class, "client/js/controller.js");
        this.addRuntimeData(() -> new FastByteArrayInputStream(("(function(g){g.id='" + this.createLiveSupportId() + "'})($);").getBytes()));
        this.addRuntimeData(() -> new FastByteArrayInputStream(("(function(g){g.Config=" + new Json().toJson(this.getConfiguration()) + "})($);").getBytes()));
        this.addRuntimeData(() -> new FastByteArrayInputStream(("(function(g){g.Styles=" + new Json().toJson((Object)this.getStyles()) + "})($);").getBytes()));
        this.addMessages(CLIENT_MESSAGES);
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="Required only for pseudo random that changes on access")
    private String createLiveSupportId() {
        String liveSupportId = "LiveSupport" + ("" + Math.random()).replaceAll("\\D", "");
        LiveSupportPreflightSessionCache.createSessionAuthToken(liveSupportId, true);
        return liveSupportId;
    }

    private String getStyles() {
        String string;
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        final FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        try {
            NopHttpServletResponse response = new NopHttpServletResponse(){

                public ServletOutputStream getOutputStream() throws IOException {
                    return new ServletOutputStream(){

                        public void write(int b) throws IOException {
                            out.write(b);
                        }

                        public void write(byte[] b, int off, int len) throws IOException {
                            out.write(b, off, len);
                        }

                        public void setWriteListener(WriteListener writeListener) {
                        }

                        public boolean isReady() {
                            return true;
                        }
                    };
                }
            };
            if (!serverPluginManager.isPluginLoaded("theme") || !LiveSupportThemeService.getInstance().doServeCorporateTheme(SessionStore.getHttpServletRequest(), (HttpServletResponse)response)) {
                try (InputStream inputStream = DEFAULT_CSS.openStream();){
                    IOFunctions.copyData((InputStream)inputStream, (OutputStream)response.getOutputStream());
                }
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                LiveSupportServerPlugin.LOGGER.error(e);
                return null;
            }
        }
        out.close();
        return string;
    }

    private Map<String, Object> getConfiguration() {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        HttpServletRequest request = SessionStore.getHttpServletRequest();
        if (request == null) {
            throw new IllegalStateException("There was no servlet request. What did you try to do?");
        }
        String rootPath = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + request.getContextPath();
        configuration.put("BASE_URL", rootPath);
        configuration.put("API_PATH", "/api/ticket");
        return configuration;
    }
}

