/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.livesupport.server.session;

import com.inet.cache.CacheTimeoutListener;
import com.inet.cache.MemoryStoreMap;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.plugins.livesupport.LiveSupportServerPlugin;
import com.inet.helpdesk.plugins.livesupport.server.notifications.LiveSupportNotificationGenerator;
import com.inet.helpdesk.shared.model.Status;
import com.inet.http.servlet.SessionStore;
import com.inet.usersandgroups.api.user.UserAccountScope;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Map;

public class LiveSupportSessionClearer
implements HttpSessionListener,
TicketEventListener {
    public static final int TIMEOUT = 300;
    private static final MemoryStoreMap<HttpSession, Integer> CACHE = new MemoryStoreMap(300, true);

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        try {
            HttpSession session = se.getSession();
            Integer ticketId = (Integer)session.getAttribute("current-livesupport-ticket");
            if (ticketId == null) {
                return;
            }
            LiveSupportServerPlugin.LOGGER.debug((Object)("Session destroyed for " + ticketId));
            LiveSupportSessionClearer.checkTicketClosed(ticketId, session);
        }
        catch (ClassCastException e) {
            return;
        }
    }

    public static void registerLiveSupportSession(Integer ticketId) {
        HttpSession session = SessionStore.getHttpSession();
        if (session == null) {
            LiveSupportServerPlugin.LOGGER.debug((Object)"Session is null (must not happen)");
            return;
        }
        if (CACHE.get((Object)session) == null) {
            LiveSupportServerPlugin.LOGGER.debug((Object)("Register session for ticket " + ticketId));
            CACHE.put((Object)session, (Object)ticketId);
        }
        LiveSupportServerPlugin.LOGGER.debug((Object)("Refresh session for ticket " + ticketId + " (" + session.getMaxInactiveInterval() + ", " + session.getLastAccessedTime() + ")"));
    }

    public static void unregisterLiveSupportSession() {
        LiveSupportSessionClearer.unregisterLiveSupportSession(SessionStore.getHttpSession());
    }

    private static void unregisterLiveSupportSession(HttpSession session) {
        if (session != null) {
            if (CACHE.get((Object)session) != null) {
                LiveSupportNotificationGenerator.clearNotification((Integer)CACHE.get((Object)session));
            }
            session.removeAttribute("current-livesupport-ticket");
            CACHE.remove((Object)session);
        }
    }

    private static void checkTicketClosed(Integer ticketId, HttpSession session) {
        TicketVO ticketVO = TicketManager.getReaderForSystem().getTicket(ticketId.intValue());
        if (ticketVO != null && !Status.isClosedOrDeletedStatus((int)ticketVO.getStatusID())) {
            ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(2);
            ReaStepTextVO reaStepTextVO = ReaStepTextVO.of((String)LiveSupportServerPlugin.MSG.getMsg("livesupport.ticket.closedDueToSessionTimeout", new Object[]{ticketId}), (boolean)false);
            ExtensionArguments extensionArgs = ExtensionArguments.create();
            MutableReaStepData reaStepData = new MutableReaStepData();
            try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                TicketManager.getManipulator().applyAction(ticketVO.getID(), reaStepData, reaStepTextVO, actionVO, extensionArgs);
                LiveSupportServerPlugin.LOGGER.info((Object)LiveSupportServerPlugin.MSG.getMsg("livesupport.ticket.closedDueToSessionTimeout", new Object[]{ticketId}));
            }
        }
        LiveSupportSessionClearer.unregisterLiveSupportSession(session);
    }

    private static void shutdownHook() {
        for (Map.Entry entry : CACHE.entrySet()) {
            try {
                LiveSupportSessionClearer.checkTicketClosed((Integer)entry.getValue(), (HttpSession)entry.getKey());
            }
            catch (Exception exception) {}
        }
    }

    public void handleEvent(TicketEvent event) {
        event.getChangedTickets().forEach(change -> {
            Integer ticketID = change.getTicketID();
            if (!CACHE.containsValue((Object)ticketID)) {
                return;
            }
            TicketVO oldTicket = change.getOldTicket();
            TicketVO newTicket = change.getNewTicket();
            if (oldTicket == null || newTicket == null) {
                return;
            }
            if (Status.isOpenStatus((int)oldTicket.getStatusID()) && !Status.isClosedOrDeletedStatus((int)newTicket.getStatusID())) {
                return;
            }
            CACHE.entrySet().parallelStream().forEach(e -> {
                if (((Integer)e.getValue()).equals(ticketID)) {
                    LiveSupportSessionClearer.unregisterLiveSupportSession((HttpSession)e.getKey());
                }
            });
        });
    }

    static {
        CACHE.addTimeoutListener((CacheTimeoutListener)new CacheTimeoutListener<HttpSession, Integer>(){

            public void timeout(HttpSession session, Integer ticketId) {
                LiveSupportServerPlugin.LOGGER.debug((Object)("Session timed out for " + ticketId));
                LiveSupportSessionClearer.checkTicketClosed(ticketId, session);
            }
        });
        ShutdownManager.add((ShutdownFinalizer)new ShutdownFinalizer(){

            public void onShutdown() {
                LiveSupportSessionClearer.shutdownHook();
            }
        });
    }
}

