/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.DataEntry;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.DataRequestData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.DataResponseData;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.SessionStore;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DataHandler
extends AbstractKnowledgeBaseHandler<DataRequestData, DataResponseData> {
    private static final String COMMAND = "web_knowledgebase_getdata";

    public String getMethodName() {
        return COMMAND;
    }

    @Override
    protected DataResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, DataRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        int dataType = input.getDataType();
        int chunkSize = input.getChunkSize();
        int currentSize = input.getCurrentSize();
        String filter = input.getFilter();
        ArrayList<Entry> data = new ArrayList<Entry>();
        switch (dataType) {
            case 19: {
                data.addAll(DataHandler.getPublishStateEntries());
                break;
            }
            case 4: {
                data.addAll(DataHandler.getCategoryEntries());
                break;
            }
            case 18: {
                data.addAll(DataHandler.getLanguageEntries());
                break;
            }
            case 5: {
                data.addAll(DataHandler.getLocationEntries());
            }
        }
        this.filterEntries(data, filter);
        ArrayList<DataEntry> result = new ArrayList<DataEntry>();
        this.convertToDataEntries(result, data, 0);
        int totalCount = result.size();
        int fromIndex = currentSize;
        int toIndex = Math.min(currentSize + chunkSize, result.size());
        DataResponseData responseData = new DataResponseData();
        responseData.setResourceList(result.subList(fromIndex, toIndex), totalCount);
        return responseData;
    }

    private void convertToDataEntries(ArrayList<DataEntry> result, ArrayList<Entry> data, int level) {
        for (Entry e : data) {
            DataEntry de = this.createDataEntry(e, level);
            result.add(de);
            ArrayList children = e.getChildren();
            if (children == null || children.size() <= 0) continue;
            this.convertToDataEntries(result, children, level + 1);
        }
    }

    private DataEntry createDataEntry(Entry e, int level) {
        String value = this.getValue(e);
        String label = e.getDisplayName();
        String icon = SessionStore.getRootURL() + "images/data/" + e.getTypeId() + "/" + (e.getTypeId() == 4 ? "" : value);
        return new DataEntry(value, label, icon, level);
    }

    private void filterEntries(ArrayList<Entry> data, String filter) {
        if (filter == null || filter.trim().length() == 0) {
            return;
        }
        filter = filter.trim().toLowerCase();
        Iterator<Entry> iterator = data.iterator();
        while (iterator.hasNext()) {
            Entry e = iterator.next();
            if (this.matches(e, filter)) continue;
            ArrayList children = e.getChildren();
            if (children != null && children.size() > 0) {
                this.filterEntries(children, filter);
                if (children.size() > 0) continue;
            }
            iterator.remove();
        }
    }

    private boolean matches(Entry e, String filter) {
        String displayName = e.getDisplayName();
        return displayName != null && (displayName = displayName.toLowerCase()).indexOf(filter) >= 0;
    }

    private String getValue(Entry e) {
        String data = e.getStringKey();
        if (data != null) {
            return data;
        }
        return String.valueOf(e.getId());
    }

    public static ArrayList<Entry> getLanguageEntries() {
        return HDUsersAndGroups.FIELD_LANGUAGE.getSearchTag().getMapData().entrySet().stream().filter(e -> {
            String value = (String)e.getValue();
            return value != null && !value.equals("xx") && !value.isEmpty();
        }).map(e -> new Entry(18, ((Comparable)e.getKey()).hashCode(), ((Comparable)e.getKey()).toString(), (String)e.getValue())).collect(Collectors.toCollection(ArrayList::new));
    }

    public static ArrayList<Entry> getCategoryEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        List all = CategoryManager.getInstance().getAll(true);
        Collections.sort(all);
        all.forEach(cat -> {
            Entry entry = new Entry(4, cat.getId(), cat.getDisplayValue());
            Entry parent = DataHandler.findParent(result, cat.getParentCategoryID());
            if (parent != null) {
                parent.addChild(entry);
            } else {
                result.add(entry);
            }
        });
        return result;
    }

    private static Entry findParent(List<Entry> result, Integer parentCategoryID) {
        if (parentCategoryID == null || parentCategoryID == 0) {
            return null;
        }
        for (Entry e : result) {
            if (e.getId() == parentCategoryID.intValue()) {
                return e;
            }
            Entry p = DataHandler.findParent(e.getChildren(), parentCategoryID);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static ArrayList<Entry> getLocationEntries() {
        int typeLocationId = 5;
        List mapData = HDUsersAndGroups.FIELD_LOCATION_ID.getSelectOptions(false);
        Collections.sort(mapData, (a, b) -> {
            int diff = Collator.getInstance(ClientLocale.getThreadLocale()).compare(a.getLabel(), b.getLabel());
            if (diff != 0) {
                return diff;
            }
            return a.getValue().compareTo(b.getValue());
        });
        return mapData.stream().map(e -> new Entry(typeLocationId, Integer.valueOf(e.getValue()).intValue(), e.getLabel())).collect(Collectors.toCollection(ArrayList::new));
    }

    public static ArrayList<Entry> getPublishStateEntries() {
        ArrayList<Entry> data = new ArrayList<Entry>();
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
            data.add(new Entry(19, PublishState.INREVIEW.ordinal(), PublishState.INREVIEW.name(), KnowledgeBaseServerPlugin.CLIENT_MSG.getMsg("knowledgebase.PublishState." + PublishState.INREVIEW.name(), new Object[0])));
        }
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_SUPPORTER)) {
            data.add(new Entry(19, PublishState.SUPPORTER.ordinal(), PublishState.SUPPORTER.name(), KnowledgeBaseServerPlugin.CLIENT_MSG.getMsg("knowledgebase.PublishState." + PublishState.SUPPORTER.name(), new Object[0])));
        }
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_ALL_LOCATIONS)) {
            data.add(new Entry(19, PublishState.LOCATION.ordinal(), PublishState.LOCATION.name(), HDUsersAndGroups.FIELD_LOCATION_ID.getLabel()));
        }
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
            data.add(new Entry(19, PublishState.ALL.ordinal(), PublishState.ALL.name(), KnowledgeBaseServerPlugin.CLIENT_MSG.getMsg("knowledgebase.PublishState." + PublishState.ALL.name(), new Object[0])));
        }
        return data;
    }
}

