/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.datacare;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceDeactivatedLocationCleanupExtension;
import com.inet.plugin.ServerPluginManager;
import java.util.List;

public class MaintenanceDeactivatedLocationCleanupExt
implements MaintenanceDeactivatedLocationCleanupExtension {
    public int findWidgetsStillUsingLocation(List<LocationVO> deactivatedLocations) {
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        try {
            return knowledgeBaseConnector.getArticlesUsingLocation(deactivatedLocations).size();
        }
        catch (ServerDataException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void cleanUpWidgetsStillUsingOneOfLocations(List<LocationVO> deactivatedLocations) {
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        try {
            List<Integer> articlesUsingLocation = knowledgeBaseConnector.getArticlesUsingLocation(deactivatedLocations);
            for (Integer id : articlesUsingLocation) {
                Article article = knowledgeBaseConnector.getArticle(id);
                article.setLocationId(-1);
                article.setPublishState(PublishState.INREVIEW);
                knowledgeBaseConnector.updateArticle(article);
                KnowledgeBaseServerPlugin.LOGGER.info((Object)("[Maintenance] Unpublished article " + id + " because the location was deleted"));
            }
        }
        catch (ServerDataException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

