/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.bot;

import com.inet.annotations.InternalApi;
import com.inet.collaboration.bot.BotResponseFormatter;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastChanged;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.CheckArticlePermission;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class KnowledgeBaseBotUtils {
    private static final Pattern KB_ID = Pattern.compile("(?i)(?<=#)\\d[^ a-zA-Z]*");
    private static final ConfigValue<String> EXTERNAL_URL = new ConfigValue(ConfigKey.SERVER_URL);
    public static final String SEARCH_REGEX = "(?i)(kb|wb|faq)\\s+(suche|search|s)\\s+(.*)";
    private static final Pattern SEARCH_PATTERN = Pattern.compile("(?i)(kb|wb|faq)\\s+(suche|search|s)\\s+(.*)");
    static KnowledgeBaseBotUtils INSTANCE = new KnowledgeBaseBotUtils();

    public static void extractKnowledgeBaseArticlesFromText(String text, Consumer<Article> handler) throws ServerDataException {
        Matcher m = KB_ID.matcher(text);
        while (m.find()) {
            String match = m.group();
            int kbID = Integer.parseInt(match = match.replaceAll("[^0-9]", ""));
            Article article = KnowledgeBaseBotUtils.getArticle(kbID);
            if (article == null) {
                handler.accept(null);
                return;
            }
            if (KnowledgeBaseBotUtils.hasAccessTo(article)) {
                handler.accept(article);
                continue;
            }
            handler.accept(null);
        }
    }

    protected Article getArticleImpl(int kbID) throws ServerDataException {
        KnowledgeBaseConnector kbConnector = KnowledgeBaseBotUtils.getKnowledgeBaseConnector();
        return kbConnector.getArticle(kbID);
    }

    private static Article getArticle(int kbID) throws ServerDataException {
        return INSTANCE.getArticleImpl(kbID);
    }

    protected boolean hasAccessToImpl(Article article) {
        return new CheckArticlePermission().hasAccessToKnowledgeBaseArticle(article.getArticleId());
    }

    private static boolean hasAccessTo(Article article) {
        return INSTANCE.hasAccessToImpl(article);
    }

    public static void runKnowledgeBaseSearchFromText(String text, Consumer<ArticleSearchResult> handler) throws ServerDataException {
        Matcher m = SEARCH_PATTERN.matcher(text);
        if (m.find()) {
            String searchTerm = m.group(3);
            KnowledgeBaseConnector kbConnector = KnowledgeBaseBotUtils.getKnowledgeBaseConnector();
            ArticleSearchResult result = kbConnector.searchArticles(UserManager.getInstance().getCurrentUserAccount(), searchTerm, searchTerm, -1, "", 5);
            handler.accept(result);
        }
    }

    protected KnowledgeBaseConnector getKnowledgeBaseConnectorImpl() {
        return (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
    }

    private static KnowledgeBaseConnector getKnowledgeBaseConnector() {
        return INSTANCE.getKnowledgeBaseConnectorImpl();
    }

    public static void postArticleToFormatter(BotResponseFormatter botResponseFormatter, Article article) {
        if (article != null) {
            String title = article.getTitle();
            int cat = article.getCategoryId();
            CategoryVO catVO = (CategoryVO)CategoryManager.getInstance().get(cat);
            String category = catVO == null ? "-" : catVO.getDisplayValue();
            String date = DateTimeUtils.dateTimeToShortFormat((long)article.getLastModified());
            String baseURL = (String)EXTERNAL_URL.get();
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            String ticketURL = baseURL + "/knowledgebase/article/" + article.getArticleId();
            String refTicketID = "" + article.getRefTicketId();
            ArrayList<BotResponseFormatter.BotResponseField> list = new ArrayList<BotResponseFormatter.BotResponseField>();
            list.add(KnowledgeBaseBotUtils.dataField(Tickets.FIELD_SUBJECT.getLabel(), title));
            list.add(KnowledgeBaseBotUtils.dataField(Tickets.FIELD_CATEGORY_ID.getLabel(), category));
            if (!"-1".equals(refTicketID)) {
                list.add(KnowledgeBaseBotUtils.dataField(KnowledgeBaseServerPlugin.MSG.getMsg("bot.fieldlabel.refticketid", new Object[0]), refTicketID));
            }
            list.add(KnowledgeBaseBotUtils.dataField(new TicketFieldDefinitionLastChanged(0).getDisplayName(), date));
            list.add(new BotResponseFormatter.BotResponseField(KnowledgeBaseServerPlugin.MSG.getMsg("bot.fieldlabel.link", new Object[0]), (BotResponseFormatter.BotResponseValue)new BotResponseFormatter.BotResponseLinkValueImpl(KnowledgeBaseServerPlugin.MSG.getMsg("bot.fieldlabel.gotoarticle", new Object[0]), ticketURL)));
            botResponseFormatter.formatResponse(title + " (#" + article.getArticleId() + ")", ticketURL, list);
        } else {
            botResponseFormatter.formatResponse(KnowledgeBaseServerPlugin.MSG.getMsg("bot.unknownarticle", new Object[0]));
        }
    }

    private static BotResponseFormatter.BotResponseField dataField(String translatedKey, String value) {
        return new BotResponseFormatter.BotResponseField(translatedKey, () -> value);
    }
}

