/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.ai.kbcreator;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.ai.CancelableExecutor;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KBConfigKeys;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.api.AIProviderManager;
import com.inet.plugin.ai.api.AIRequest;
import com.inet.plugin.ai.api.AIResponse;
import com.inet.plugin.ai.api.AITool;
import com.inet.plugin.ai.api.AIToolException;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.api.ResponseHandler;
import java.awt.Font;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KnowledgeBaseEntryCreationExecutor
implements CancelableExecutor {
    private final int ticketId;
    private final String clientId;
    private final AIProviderManager manager;
    private AIResponse response;
    private boolean canceled;
    private static final ConfigValue<String> EXTRA_KB_ENTRY_INSTRUCTIONS = new ConfigValue(KBConfigKeys.KB_ENTRY_EXTRA_INSTRUCTIONS_KEY);
    private static final ConfigValue<Boolean> KB_ENTRY_USEDEFAULT = new ConfigValue(KBConfigKeys.AI_KB_ENTRY_USEDEFAULTPROVIDER);
    private static final ConfigValue<String> AI_REWRITE_MANUALPROVIDER = new ConfigValue(KBConfigKeys.AI_KB_ENTRY_MANUALPROVIDER);

    public KnowledgeBaseEntryCreationExecutor(int ticketReference, String clientId, AIProviderManager manager) {
        this.ticketId = ticketReference;
        if (clientId == null) {
            clientId = GUID.generateNew().toString();
        }
        this.clientId = clientId;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Article getAIGeneratedArticle() {
        if (this.clientId != null) {
            CancelableExecutor.addExecuter((String)this.clientId, (CancelableExecutor)this);
        }
        TicketReader reader = this.getReader();
        try {
            Object providerName;
            Communicator communicator;
            TicketVO ticket = reader.getTicket(this.ticketId);
            if (ticket == null) {
                KnowledgeBaseServerPlugin.LOGGER.warn((Object)("Ticket " + this.ticketId + " not found \u2013 returning empty article."));
                Article article = new Article();
                return article;
            }
            ServerValuesConnector svc = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
            Font defaultFont = svc != null ? svc.getDefaultFont() : null;
            final Article article = KnowledgeBaseUtils.getArticleFromTicket(this.ticketId, defaultFont);
            article.setPublishState(PublishState.INREVIEW);
            Boolean useDefault = (Boolean)KB_ENTRY_USEDEFAULT.get();
            if (useDefault == null || useDefault.booleanValue()) {
                communicator = this.manager.getDefaultCommunicator();
            } else {
                providerName = (String)AI_REWRITE_MANUALPROVIDER.get();
                if (providerName == null || ((String)providerName).isBlank()) {
                    KnowledgeBaseServerPlugin.LOGGER.warn((Object)"AI Provider empty \u2013 returning empty article.");
                    Article article2 = new Article();
                    return article2;
                }
                communicator = this.manager.getCommunicator((String)providerName);
            }
            if (communicator == null) {
                KnowledgeBaseServerPlugin.LOGGER.warn((Object)"No AI communicator available for KB problem/solution generation.");
                providerName = article;
                return providerName;
            }
            ResponseHandler handler = new ResponseHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(@Nonnull AIResponse response) {
                    KnowledgeBaseEntryCreationExecutor knowledgeBaseEntryCreationExecutor = KnowledgeBaseEntryCreationExecutor.this;
                    synchronized (knowledgeBaseEntryCreationExecutor) {
                        KnowledgeBaseEntryCreationExecutor.this.response = response;
                        KnowledgeBaseEntryCreationExecutor.this.notifyAll();
                    }
                }
            };
            List stepsForTicket = reader.getReaStepsForTicket(this.ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
            List steps = stepsForTicket.stream().filter(step -> step.getActionID() != -6).sorted((step1, step2) -> {
                int diff = Long.compare(step1.getEndDate(), step2.getEndDate());
                if (diff != 0) {
                    return diff;
                }
                return Integer.compare(step1.getID(), step2.getID());
            }).map(rea -> this.generateEntryForReaStep(ticket, (ReaStepVO)rea)).filter(m -> m != null).collect(Collectors.toList());
            String historyJson = new Json().toJson(steps);
            final Locale threadLocale = ClientLocale.getThreadLocale();
            List<@Nonnull KnowledgeBaseEntryCreationExecutor.2> tools = List.of(new AITool(){

                public String getName() {
                    return "createKnowledgeBaseEntry";
                }

                public String getDescription() {
                    return "creates a knowledge base entry";
                }

                @Nonnull
                public List<AITool.ParameterDescription> getRequiredParameters() {
                    return List.of(new AITool.ParameterDescription("problem", "A concise summary of the PRIMARY problem of the entry", AITool.ParameterType.string), new AITool.ParameterDescription("solution", "A concise summary of the PRIMARY solution of the entry", AITool.ParameterType.string));
                }

                @Nonnull
                public List<AITool.ParameterDescription> getOptionalParameters() {
                    return new ArrayList<AITool.ParameterDescription>();
                }

                @Nullable
                public Object call(Map<String, Object> map) throws AIToolException {
                    Object problemObj = map.get("problem");
                    Object solutionObj = map.get("solution");
                    if (problemObj != null) {
                        article.setProblem(problemObj.toString());
                    }
                    if (solutionObj != null) {
                        article.setSolution(solutionObj.toString());
                    }
                    article.setLanguageId(threadLocale.getLanguage().toLowerCase());
                    return null;
                }
            });
            AIRequest request = new AIRequest("KnowledgeBase Ticket Analysis", "" + this.ticketId, handler, null, tools);
            Object systemPrompt = "**Role:** You are an AI assistant specializing in creating concise, problem-solution knowledge base articles from customer support ticket histories.\n**Objective:** Analyze the provided ticket history to identify the primary customer problem and its corresponding solution. Your output will be used to populate a public-facing FAQ system. The 'problem' description should be clear and accurate for customers. The 'solution' should serve as a practical, actionable guideline for customers and support team members. The output must be entirely free of personal user data.\n**Instructions:**\n";
            systemPrompt = (String)systemPrompt + "* **Language:** *ALWAYS* generate the entire response in **" + threadLocale.getDisplayLanguage(Locale.ENGLISH).toUpperCase() + "**.\n";
            systemPrompt = (String)systemPrompt + "* **Content Extraction:**\n    * Focus *ONLY* on extracting the core **problem** described by the customer. When extracting the problem, prioritize identifying and including the *exact wording* of any error messages, codes, or specific symptoms mentioned by the customer. If an error message is present, format it clearly within the problem description (e.g., by enclosing it in `<code>` tags for specific formatting, or `<strong>` for emphasis).\n    * For the **solution**, synthesize the steps taken in the ticket into a general, actionable guideline for customers and support agents. This guideline should explain *how to resolve* the problem, not just *what was done* in this specific case. It should be presented as clear, concise steps a user and support agent can follow.\n* **Data Privacy:** *ABSOLUTELY DO NOT* include any personally identifiable information (PII) such as names, email addresses, account numbers, locations, employees, dates or specific timestamps of user actions. General descriptions of the problem and solution are permitted.\n* **Output Format:** You *MUST* call the `createKnowledgeBaseEntry` tool with exactly two properties: `problem` and `solution`.\n    * Each value (`problem` and `solution`) must be a short, clear HTML-formatted paragraph or two. You can use HTML lists (`<ul>`, `<ol>`, `<li>`) within the `solution` to present steps if appropriate.\n    * Do not use Markdown formatting within the `problem` or `solution` values.\n    * Do not use phrases like 'the user', 'the customer', always describe the problem itself.\n    * Example of `createKnowledgeBaseEntry` tool call:\n      ```json\n      {\n        \"tool_code\": \"createKnowledgeBaseEntry\",\n        \"parameters\": {\n          \"problem\": \"<p>Description of the problem in HTML. If an error message was present, it should be exact, e.g., 'An unexpected error occurred: <code>Error Code 123</code>.'</p>\",\n          \"solution\": \"<p>Guideline in continuous prose for customers and support agents in HTML, e.g.:</p><ul><li>Step 1: Check browser cache.</li><li>Step 2: Disable browser extensions.</li></ul>\"\n        }\n      }\n      ```\n* **Conciseness:** Be as brief as possible while ensuring the problem and solution are fully understandable and actionable.\n* **Tone:** Maintain a neutral, informative, and professional tone for the problem description. For the solution, adopt a clear, instructive tone suitable for internal support guidelines.\n\nHere is the ticket history as JSON:\n" + historyJson;
            String extra = (String)EXTRA_KB_ENTRY_INSTRUCTIONS.get();
            if (extra != null && !extra.isBlank()) {
                systemPrompt = (String)systemPrompt + "\n\n" + extra.trim();
            }
            systemPrompt = (String)systemPrompt + historyJson;
            request.setSystemPrompt((String)systemPrompt);
            request.setForceTool(true);
            communicator.runRequest(request);
            Object object = this;
            synchronized (object) {
                try {
                    if (this.response == null) {
                        this.wait(60000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.response == null || this.response.getResponseText() == null) {
                KnowledgeBaseServerPlugin.LOGGER.warn((Object)("AI did not return a problem/solution for ticket " + this.ticketId));
                object = article;
                return object;
            }
            if (this.canceled) {
                KnowledgeBaseServerPlugin.LOGGER.warn((Object)"AI request canceled");
                object = article;
                return object;
            }
            object = article;
            return object;
        }
        catch (Exception ex) {
            KnowledgeBaseServerPlugin.LOGGER.error("Error creating article from ticket", (Throwable)ex);
            Article article = new Article();
            return article;
        }
        finally {
            if (this.clientId != null) {
                CancelableExecutor.removeExecuter((String)this.clientId);
            }
        }
    }

    protected TicketReader getReader() {
        return TicketManager.getReader();
    }

    @Nullable
    protected Map<String, Object> generateEntryForReaStep(TicketVO ticket, @Nonnull ReaStepVO step) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ReaStepTextVO reaStepText = this.getReader().getReaStepText(step.getID());
        if (reaStepText != null) {
            String stepContent = reaStepText.getText();
            if (StringFunctions.isEmpty((String)stepContent)) {
                return null;
            }
            String plainText = HtmlConverter.html2text((String)stepContent);
            if (plainText == null || plainText.isBlank()) {
                return null;
            }
            result.put("text", plainText);
            result.put("date", DateTimeFormatter.ISO_DATE_TIME.format(new Date(step.getStartDate()).toInstant().atZone(ZoneId.systemDefault())));
            result.put("userDisplayName", step.getDisplayName());
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExecution() {
        KnowledgeBaseEntryCreationExecutor knowledgeBaseEntryCreationExecutor = this;
        synchronized (knowledgeBaseEntryCreationExecutor) {
            this.response = null;
            this.canceled = true;
            this.notifyAll();
        }
    }
}

