/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.server.ArticlePrintPermissionChecker;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CreateArticlePdf
extends AbstractKnowledgeBaseHandler<Void, Void> {
    public String getMethodName() {
        return "web_knowledgebase_createarticlepdf";
    }

    @Override
    public short getMethodType() {
        return 2;
    }

    @Override
    public Void handleRequest(HttpServletRequest request, HttpServletResponse resp, Void input, UserAccount currentUser) throws ClientMessageException {
        try {
            String articleId = request.getParameter("id");
            Engine eng = new Engine("pdf");
            eng.setReportFile(ArticlePrintPermissionChecker.REPORT_URL);
            String title = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.printpdf.title", new Object[]{articleId});
            resp.setContentType("application/pdf");
            Object fileName = ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getApplicationName();
            fileName = (String)fileName + " - " + title.trim();
            eng.getSummaryInfo().setReportTitle((String)fileName);
            eng.setLocale(ClientLocale.getThreadLocale());
            eng.setPrompt("articleId", articleId);
            eng.setPrompt("currentTimeStamp", String.valueOf(System.currentTimeMillis()));
            eng.execute();
            fileName = (String)fileName + ".pdf";
            ServletUtils.setContentDisposition((HttpServletResponse)resp, (String)fileName, (boolean)false);
            ServletOutputStream out = resp.getOutputStream();
            for (int i = 1; i <= eng.getPageCount(); ++i) {
                out.write(eng.getPageData(i));
            }
        }
        catch (ReportException e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
        }
        catch (IOException e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
        }
        return null;
    }
}

