/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.ArticlePreview;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.LoadArticlePreviewsRequestData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.LoadArticlePreviewsResponseData;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoadArticlePreviews
extends AbstractKnowledgeBaseHandler<LoadArticlePreviewsRequestData, LoadArticlePreviewsResponseData> {
    public String getMethodName() {
        return "web_knowledgebase_loadarticlepreviews";
    }

    @Override
    protected LoadArticlePreviewsResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, LoadArticlePreviewsRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        Map locations = HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData();
        Set<Integer> favoriteArticleIds = knowledgeBaseConnector.getFavoriteArticleIds(HDUsersAndGroups.getUserID((UserAccount)currentUser));
        String searchQuery = input.getSearchTerm();
        if (searchQuery == null) {
            searchQuery = "";
        }
        String searchID = input.getSearchID();
        ArticleSearchResult articleSearchResult = null;
        boolean isSearch = !searchQuery.trim().isEmpty();
        articleSearchResult = isSearch ? knowledgeBaseConnector.searchArticles(currentUser, searchQuery, searchID, input.getCategoryId(), input.getLanguage(), 100) : knowledgeBaseConnector.getFrontArticles(currentUser, input.getCategoryId(), input.getLanguage(), 10, 25);
        List<Article> articles = articleSearchResult.getArticles();
        String defaultCategoryName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.none", new Object[0]);
        ArrayList<ArticlePreview> articleDescriptions = new ArrayList<ArticlePreview>();
        Iterator<Article> iterator = articles.iterator();
        while (iterator.hasNext()) {
            ArticlePreview ap = this.convertToPreview(iterator.next(), favoriteArticleIds, locations, defaultCategoryName);
            if (isSearch) {
                ap.generatePreviewText();
            }
            articleDescriptions.add(ap);
        }
        int languageTypeId = 18;
        return new LoadArticlePreviewsResponseData(articleDescriptions, articleSearchResult.getCategories(), articleSearchResult.getLanguages(), languageTypeId, articleSearchResult.getDraftCount(), KnowledgeBaseServerPlugin.MSG.getMsg("Field.ARTICLE_PUBLISHSTATE", new Object[0]) + ":" + KnowledgeBaseServerPlugin.CLIENT_MSG.getMsg("knowledgebase.PublishState.INREVIEW", new Object[0]).replace(' ', '-'), articleSearchResult.isHasMoreEntries());
    }

    private ArticlePreview convertToPreview(Article article, Set<Integer> favoriteArticleIds, Map<Integer, String> locations, String defaultCategoryName) {
        CategoryVO categoryVO = (CategoryVO)CategoryManager.getInstance().get(article.getCategoryId());
        String categoryDisplayName = defaultCategoryName;
        if (categoryVO != null && !StringFunctions.isEmpty((String)categoryVO.getPath())) {
            categoryDisplayName = categoryVO.getPath();
            if (categoryVO.isDeleted()) {
                categoryDisplayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.deleted", new Object[]{categoryDisplayName});
            }
        } else if (categoryVO == null) {
            categoryDisplayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.deleted.missing", new Object[]{String.valueOf(article.getCategoryId())});
        }
        ArticlePreview articlePreview = new ArticlePreview(article.getArticleId(), article.getTitle(), null, article.getPublishState(), categoryDisplayName, article.getCategoryId(), locations.get(article.getLocationId()), article.getLastModified(), article.isPinned(), favoriteArticleIds.contains(article.getArticleId()));
        articlePreview.setArticleReference(article);
        return articlePreview;
    }
}

