/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.bot;

import com.inet.collaboration.bot.BotCommand;
import com.inet.collaboration.bot.BotCommandContext;
import com.inet.collaboration.bot.BotResponseFormatter;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.bot.KnowledgeBaseBotUtils;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import java.util.ArrayList;
import java.util.List;

public class KnowledgeBaseSearchBotCommand
implements BotCommand {
    public static final String SEARCH_REGEX = "(?i)(kb|wb|faq)\\s+(suche|search|s)\\s+(.*)";

    public String getCommandRegex() {
        return SEARCH_REGEX;
    }

    public void respondToCommand(BotCommandContext context, String text, BotResponseFormatter botResponseFormatter) {
        try {
            KnowledgeBaseBotUtils.runKnowledgeBaseSearchFromText(text, result -> {
                List<Article> articles = result.getArticles();
                if (articles.size() > 0) {
                    articles.forEach(article -> KnowledgeBaseBotUtils.postArticleToFormatter(botResponseFormatter, article));
                } else {
                    botResponseFormatter.formatResponse(KnowledgeBaseServerPlugin.MSG.getMsg("bot.noarticlesfound", new Object[0]));
                }
            });
        }
        catch (Exception e) {
            KnowledgeBaseServerPlugin.LOGGER.error((Throwable)e);
        }
    }

    public List<String> getSyntaxExamples() {
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
            return List.of(KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbsearchshortcut", new Object[0]), KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbsearchshortcut2", new Object[0]), KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbsearchshortcut3", new Object[0]));
        }
        return new ArrayList<String>();
    }

    public String getHelpDescription() {
        if (SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE)) {
            return KnowledgeBaseServerPlugin.MSG.getMsg("bot.help.kbsearch", new Object[0]);
        }
        return null;
    }
}

