/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.setup;

import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.utils.DatabaseVersionChecker;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachment;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseConnectorImpl;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.plugins.setupwizard.api.ReIndexTicketsListener;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.SuppressFBWarnings;

public class KnowledgeBaseSetupStep
extends AutoSetupStep {
    private static final int KB_EXPERTS = 1;
    private static final int KB_LOCATION = 2;
    private Pattern kbLinkPattern = Pattern.compile("(<a\\s.*?href=\")([^\"]*?\\?kb=\\d+[^\"]*?)(\")");
    private Pattern kbPatternV_8_1_htmlclient = Pattern.compile("(<a\\s.*?href=\")([^\"]*?/htmlclient/knowledgebase/[^\"]*?)(\")");
    private Pattern kbPatternV_8_1_relativekb = Pattern.compile("(<a\\s.*?href=\")(knowledgebase)(\")");
    private Pattern kbSampleImage = Pattern.compile("(<img\\s.*?src=\")([^\"]*?)(\")");
    private KnowledgeBaseConnectorImpl knowledgeBaseConnector;

    public KnowledgeBaseSetupStep(KnowledgeBaseConnectorImpl knowledgeBaseConnector) {
        this.knowledgeBaseConnector = knowledgeBaseConnector;
    }

    public StepKey stepKey() {
        return new StepKey("knowledgebase.setup");
    }

    public String getStepDisplayName() {
        return KnowledgeBaseServerPlugin.MSG.getMsg("setup.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        boolean databaseStructureChanged = new DatabaseVersionChecker().isDatabaseStructureChanged(KnowledgeBaseServerPlugin.class);
        if (databaseStructureChanged) {
            return true;
        }
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs == null || dbConfigs.isEmpty()) {
            return true;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        if (dbInfo == null) {
            return true;
        }
        try {
            if (HdDatabaseCheck.tableExists((DatabaseConnectionFactory)((DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class)), (String)"tblKnowledgeBase")) {
                return false;
            }
        }
        catch (SQLException t) {
            SetupLogger.LOGGER.debug((Object)t);
            return true;
        }
        catch (Throwable e) {
            SetupLogger.LOGGER.error(e);
            return true;
        }
        return true;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        boolean kbTableExists = false;
        boolean ticketExist = false;
        try {
            LoaderUtils.classForName((String)dbInfo.getDriverClassName(), (Object)((Object)this));
            try (Connection connection = DriverManager.getConnection(dbInfo.getUrl(), dbInfo.getUser(), dbInfo.getDecodedPassword());){
                try (ResultSet tables = connection.getMetaData().getTables(dbInfo.getCatalogForConnection(), DatabaseConfigInfo.DatabaseType.inetora.equals((Object)dbInfo.getDriver()) ? dbInfo.getUser().toUpperCase() : null, "tblKnowledgeBase", new String[]{"TABLE"});){
                    if (tables.next()) {
                        kbTableExists = true;
                    }
                }
                catch (Throwable t) {
                    SetupLogger.LOGGER.debug((Object)t);
                }
                try (Statement stmt = connection.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT count(AufID) FROM tblAuftraege");){
                    if (rs.next()) {
                        ticketExist = rs.getInt(1) > 0;
                    }
                }
                catch (Throwable t) {
                    SetupLogger.LOGGER.debug((Object)t);
                }
            }
        }
        catch (Throwable t) {
            SetupLogger.LOGGER.error(t);
        }
        boolean migrateArticles = !kbTableExists && ticketExist;
        boolean createSamples = !kbTableExists && !ticketExist;
        try {
            DBUpdateBackdoor dbUpdater = (DBUpdateBackdoor)ServerPluginManager.getInstance().getSingleInstance(DBUpdateBackdoor.class);
            dbUpdater.updateDB(dbInfo, KnowledgeBaseServerPlugin.class, null, null, event -> this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(0, () -> event.getCurrentJobName(ClientLocale.getThreadLocale()))));
            new DatabaseVersionChecker().markDatabaseStructureChanged(KnowledgeBaseServerPlugin.class);
            this.knowledgeBaseConnector.initialize();
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
        Consumer<Integer> articleCallback = id -> {
            if (id != null) {
                try {
                    this.knowledgeBaseConnector.updateArticleCacheAndIndex((int)id);
                }
                catch (ServerDataException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Consumer<Integer> ticketCallback = id -> {};
        if (createSamples) {
            this.doCreateSamples();
        }
        boolean likeSyntaxSupported = true;
        if (migrateArticles || kbTableExists) {
            likeSyntaxSupported = this.checkLikeSyntaxSupported();
            ReIndexTicketsListener.triggerReIndexOfTicketsAfterSetup();
        }
        if (migrateArticles) {
            this.doMigrateArticles(articleCallback, ticketCallback, likeSyntaxSupported);
        }
        if (kbTableExists) {
            this.doPatchVersion81KBLinks(articleCallback, ticketCallback, likeSyntaxSupported);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean checkLikeSyntaxSupported() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doCreateSamples() throws StepExecutionException {
        try {
            Integer sonstiges;
            HashMap<String, Integer> categories = KnowledgeBaseUtils.collectCategories(null);
            int catId = 0;
            Integer software = categories.get("Software");
            if (software != null) {
                catId = software;
            }
            if (catId <= 0 && (sonstiges = categories.get("Sonstiges")) != null) {
                catId = sonstiges;
            }
            if (catId <= 0 && !categories.isEmpty()) {
                catId = categories.values().iterator().next();
            }
            int sampleCount = 14;
            for (int i = 1; i <= sampleCount; ++i) {
                Integer currentSample = i;
                this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(50 + (int)Math.round((double)(i - 1) / (double)sampleCount * 50.0), () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.samples.creation", new Object[]{currentSample})));
                this.importSample(catId, i);
            }
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
    }

    private void importSample(int catId, int sampleId) throws IOException, ServerDataException {
        KnowledgeBaseConnector kbc = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        URL sample1 = ((Object)((Object)this)).getClass().getResource("samples/sample" + sampleId + ".json");
        if (sample1 == null) {
            return;
        }
        try (InputStream articleInput = sample1.openStream();){
            final Article article = (Article)new Json().fromJson(articleInput, Article.class);
            article.setLastEditorId(0);
            article.setLastModified(System.currentTimeMillis());
            article.setCategoryId(catId);
            final int articleId = kbc.createArticle(article);
            if (article.isPinned()) {
                kbc.savePinState(articleId, true);
            }
            try {
                ServerPluginManager.getInstance().runIfPluginLoaded("attachments", () -> new Executable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File path is only filled with hard coded data. No user input is possible.")
                    public void execute() {
                        Matcher imageMatcher = KnowledgeBaseSetupStep.this.kbSampleImage.matcher(article.getSolution());
                        while (imageMatcher.find()) {
                            String sampleImageName = imageMatcher.group(2);
                            try {
                                URL attachment = ((Object)((Object)this)).getClass().getResource("samples/" + sampleImageName);
                                if (attachment == null) continue;
                                final File tempAttachment = File.createTempFile("knowledgebase", sampleImageName);
                                try {
                                    try (FileOutputStream attachmentOutput = new FileOutputStream(tempAttachment);
                                         InputStream attachmentInput = attachment.openStream();){
                                        IOFunctions.copyData((InputStream)attachmentInput, (OutputStream)attachmentOutput);
                                    }
                                    KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseAttachmentConnector.class);
                                    LargeContent[] added = new LargeContent[]{new LargeContent(new LargeContent.InputStreamProvider(){

                                        public long getSize() {
                                            return tempAttachment.length();
                                        }

                                        public InputStream getStream() {
                                            try {
                                                return new FileInputStream(tempAttachment);
                                            }
                                            catch (FileNotFoundException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                    })};
                                    added[0].setContentType(AttachmentType.EmbeddedImage);
                                    added[0].setLastModified(System.currentTimeMillis());
                                    added[0].setName(sampleImageName);
                                    kbac.updateArticleAttachments(articleId, added, null, null);
                                }
                                finally {
                                    tempAttachment.delete();
                                }
                            }
                            catch (ServerDataException | IOException exc) {
                                throw new RuntimeException(exc);
                            }
                        }
                    }
                });
            }
            catch (RuntimeException exc) {
                Throwable t = exc.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof ServerDataException) {
                    throw (ServerDataException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw exc;
            }
        }
    }

    private void doPatchVersion81KBLinks(Consumer<Integer> articleCallback, Consumer<Integer> ticketCallback, boolean likeSyntaxSupported) throws StepExecutionException {
        try {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            try (Connection connection = connectionFactory.getConnection();){
                int progressAsPercentage = 90;
                this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(90, () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.migration.progresspatching", new Object[0])));
                AtomicInteger processedRowsCount = new AtomicInteger(0);
                Runnable updateExecutionProgress = () -> {
                    int alreadyProcessedRows = processedRowsCount.incrementAndGet();
                    StepExecutionProgressInfo.ProgressMessageProvider msgProvider = () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.migration.progresspatchingwithcount", new Object[]{String.valueOf(alreadyProcessedRows)});
                    this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(90, msgProvider));
                };
                this.patchKbV81LinksInTable(connection, "tblKnowledgeBaseProblem", "articleId", "articleId", "problem", true, articleCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblKnowledgeBase", "articleId", "articleId", "solution", true, articleCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblAuftraege", "AufID", "AufID", "Auftrag", false, ticketCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblRealisierung", "ReaID", "ReaID", "was", false, ticketCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblQuickTicket", "QuiID", "QuiID", "Auftrag", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblQuickTicket", "QuiID", "QuiID", "BearbeitungsText", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblSerienaufgaben", "SerID", "SerID", "Auftrag", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblTextbausteine", null, "UsrID, KurzText", "LangText", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbV81LinksInTable(connection, "tblWorkFlowDetails", null, "WfmID, WFStep", "Auftext", false, null, likeSyntaxSupported, updateExecutionProgress);
            }
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
    }

    private void doMigrateArticles(Consumer<Integer> articleCallback, Consumer<Integer> ticketCallback, boolean likeSyntaxSupported) throws StepExecutionException {
        try {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            try (Connection connection = connectionFactory.getConnection();){
                int minKbSetting = 2;
                try (Statement st = connection.createStatement();
                     ResultSet rs = st.executeQuery("SELECT WB_Standard FROM tblOptionen");){
                    if (rs.next()) {
                        minKbSetting = rs.getInt(1) == 1 ? 2 : 1;
                    }
                }
                catch (SQLException sqle) {
                    SetupLogger.LOGGER.warn((Object)"Column WB_Standard not found in tblOptionen. Database structure is new. Only try to migrate non expert tickets.");
                    SetupLogger.LOGGER.warn((Object)sqle);
                }
                ServerValuesConnector svc = (ServerValuesConnector)spm.getSingleInstance(ServerValuesConnector.class);
                Font defaultFont = svc.getDefaultFont();
                ArrayList<Integer> ticketIDs = new ArrayList<Integer>();
                try (PreparedStatement pst = connection.prepareStatement("SELECT tblAuftraege.BunID FROM tblBuendel INNER JOIN tblAuftraege ON tblBuendel.BunID=tblAuftraege.BunID WHERE (Status = -200 AND Wissensbasis>0) OR (Status>=300 AND Status<400 AND Wissensbasis>=?) GROUP BY tblAuftraege.BunID ORDER BY tblAuftraege.BunID");){
                    pst.setInt(1, minKbSetting);
                    try (ResultSet rs = pst.executeQuery();){
                        while (rs.next()) {
                            ticketIDs.add(rs.getInt(1));
                        }
                    }
                }
                catch (SQLException sqle) {
                    SetupLogger.LOGGER.warn((Object)"Could not get all tickets with the required publishing state.");
                    SetupLogger.LOGGER.warn((Object)sqle);
                }
                HashMap<Integer, Integer> ticketToArticles = new HashMap<Integer, Integer>();
                for (int i = 0; i < ticketIDs.size(); ++i) {
                    Integer ticketId = (Integer)ticketIDs.get(i);
                    Integer currentNr = i + 1;
                    this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(50 + (int)Math.ceil((double)i / (double)ticketIDs.size() * 40.0), () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.migration.progress", new Object[]{ticketId.toString(), currentNr.toString(), String.valueOf(ticketIDs.size())})));
                    int articleId = this.migrateTicketIntoArticle(connection, ticketId, defaultFont);
                    if (articleId == -1) continue;
                    ticketToArticles.put(ticketId, articleId);
                }
                int progressAsPercentage = 90;
                this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(90, () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.migration.progresspatching", new Object[0])));
                AtomicInteger processedRowsCount = new AtomicInteger(0);
                Runnable updateExecutionProgress = () -> {
                    int alreadyProcessedRows = processedRowsCount.incrementAndGet();
                    StepExecutionProgressInfo.ProgressMessageProvider msgProvider = () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.migration.progresspatchingwithcount", new Object[]{String.valueOf(alreadyProcessedRows)});
                    this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(90, msgProvider));
                };
                this.patchKbLinksInTable(ticketToArticles, connection, "tblKnowledgeBaseProblem", "articleId", "articleId", "problem", true, articleCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblKnowledgeBase", "articleId", "articleId", "solution", true, articleCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblAuftraege", "AufID", "AufID", "Auftrag", false, ticketCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblRealisierung", "ReaID", "ReaID", "was", false, ticketCallback, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblQuickTicket", "QuiID", "QuiID", "Auftrag", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblQuickTicket", "QuiID", "QuiID", "BearbeitungsText", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblSerienaufgaben", "SerID", "SerID", "Auftrag", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblTextbausteine", null, "UsrID, KurzText", "LangText", false, null, likeSyntaxSupported, updateExecutionProgress);
                this.patchKbLinksInTable(ticketToArticles, connection, "tblWorkFlowDetails", null, "WfmID, WFStep", "Auftext", false, null, likeSyntaxSupported, updateExecutionProgress);
            }
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
    }

    private int migrateTicketIntoArticle(Connection connection, final int ticketId, Font defaultFont) throws SQLException, ServerDataException {
        try (UserAccountScope priv = UserAccountScope.createPrivileged();){
            ServerPluginManager spm = ServerPluginManager.getInstance();
            KnowledgeBaseConnector kbc = (KnowledgeBaseConnector)spm.getSingleInstance(KnowledgeBaseConnector.class);
            SetupLogger.LOGGER.info((Object)("Migrating ticket #" + ticketId + " into an article"));
            Article article = KnowledgeBaseUtils.getArticleFromTicket(ticketId, defaultFont);
            if (article != null) {
                final int articleId = kbc.createArticle(article);
                try {
                    spm.runIfPluginLoaded("attachments", () -> new Executable(){

                        public void execute() {
                            List<KnowledgeBaseAttachment> attachmentsCopied = KnowledgeBaseUtils.getTicketAttachments(ticketId);
                            SetupLogger.LOGGER.info((Object)String.format("Migrate %d attachments for article", attachmentsCopied.size()));
                            KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseAttachmentConnector.class);
                            try {
                                kbac.updateArticleAttachments(articleId, null, attachmentsCopied, null);
                            }
                            catch (ServerDataException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    SetupLogger.LOGGER.error(t);
                    article.setPublishState(PublishState.INREVIEW);
                    kbc.updateArticle(article);
                }
                int n = articleId;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is build with hard coded limit values. No user input available, therefor no SQL injection is possible.")
    private void patchKbLinksInTable(HashMap<Integer, Integer> ticketToArticles, Connection connection, String table, String idColumn, String primaryColumns, String column, boolean relativeLink, Consumer<Integer> callback, boolean likeSyntaxSupported, Runnable updateExecutionProgress) {
        try {
            if (!HdDatabaseCheck.tableExists((DatabaseConnectionFactory)((DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class)), (String)table)) {
                return;
            }
        }
        catch (Throwable t) {
            SetupLogger.LOGGER.error(t);
        }
        int minIndex = 0;
        int maxIndex = 0;
        if (idColumn == null) {
            this.patchKbLinksInTableForRange(ticketToArticles, connection, table, idColumn, primaryColumns, column, relativeLink, callback, likeSyntaxSupported, updateExecutionProgress, minIndex, maxIndex);
            return;
        }
        int CHUNK_SIZE = 5000;
        BiFunction<Integer, Integer, List> generateThresholds = (min, max) -> {
            int value = min;
            ArrayList<Integer> thresholds = new ArrayList<Integer>();
            while (value < max) {
                thresholds.add(value += 5000);
            }
            thresholds.add((Integer)max);
            return thresholds;
        };
        try (Statement stmt = connection.createStatement();
             ResultSet minAndMax = stmt.executeQuery("select min(" + idColumn + "), max(" + idColumn + ") from " + table);){
            if (!minAndMax.next()) {
                SetupLogger.LOGGER.warn((Object)("No entry found in " + table + "!"));
                return;
            }
            int min2 = minAndMax.getInt(1);
            int max2 = minAndMax.getInt(2);
            List chunkThresholds = generateThresholds.apply(min2, max2);
            int current = min2;
            for (Integer threshold : chunkThresholds) {
                minIndex = current;
                maxIndex = threshold;
                this.patchKbLinksInTableForRange(ticketToArticles, connection, table, idColumn, primaryColumns, column, relativeLink, callback, likeSyntaxSupported, updateExecutionProgress, current, maxIndex);
                current = threshold + 1;
            }
        }
        catch (SQLException e) {
            SetupLogger.LOGGER.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is build with hard coded values. No user input available, therefore no SQL injection is possible.")
    private void patchKbLinksInTableForRange(HashMap<Integer, Integer> ticketToArticles, Connection connection, String table, String idColumn, String primaryColumns, String column, boolean relativeLink, Consumer<Integer> callback, boolean likeSyntaxSupported, Runnable updateExecutionProgress, int minIndex, int maxIndex) {
        String sql = "SELECT " + primaryColumns + ", " + column + " FROM " + table;
        if (idColumn != null) {
            sql = sql + " WHERE " + idColumn + " BETWEEN " + minIndex + " AND " + maxIndex;
        }
        if (likeSyntaxSupported) {
            sql = idColumn == null ? sql + " WHERE" : sql + " AND";
            sql = sql + " " + column + " LIKE '%href=%?kb=%'";
        }
        try (Statement st = connection.createStatement(1005, 1008);
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                block29: {
                    try {
                        String content = rs.getString(column);
                        if (content == null) break block29;
                        Matcher m = this.kbLinkPattern.matcher(content);
                        StringBuffer sb = new StringBuffer(content.length());
                        boolean foundMatch = false;
                        while (m.find()) {
                            Integer articleId;
                            foundMatch = true;
                            String linkStart = m.group(1);
                            Object href = m.group(2);
                            String linkEnd = m.group(3);
                            int ticketId = -1;
                            int indexOfKbKey = ((String)href).indexOf("kb=");
                            if (indexOfKbKey >= 0) {
                                try {
                                    ticketId = NumberFormat.getIntegerInstance().parse(((String)href).substring(indexOfKbKey + 3)).intValue();
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                            }
                            Integer n = articleId = ticketId == -1 ? null : ticketToArticles.get(ticketId);
                            if (relativeLink) {
                                href = articleId == null ? "" : "article/" + articleId;
                            } else {
                                int indexOfJnlpContext = ((String)href).indexOf("/jnlp");
                                if (indexOfJnlpContext >= 0) {
                                    href = ((String)href).substring(0, indexOfJnlpContext);
                                    href = (String)href + "/knowledgebase/";
                                    if (articleId != null) {
                                        href = (String)href + "article/" + articleId;
                                    }
                                }
                            }
                            m.appendReplacement(sb, Matcher.quoteReplacement(linkStart + (String)href + linkEnd));
                        }
                        m.appendTail(sb);
                        if (foundMatch) {
                            rs.updateString(column, sb.toString());
                            rs.updateRow();
                            if (callback != null) {
                                callback.accept(rs.getInt(primaryColumns));
                            }
                        }
                    }
                    catch (Throwable t) {
                        SetupLogger.LOGGER.warn((Object)("Could not update knowledge base links in table '" + table + "'."));
                        SetupLogger.LOGGER.warn((Object)t);
                    }
                }
                updateExecutionProgress.run();
            }
        }
        catch (Throwable t) {
            SetupLogger.LOGGER.warn((Object)("Could not read entries with knowledge base links from table '" + table + "'."));
            SetupLogger.LOGGER.warn((Object)t);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is build with hard coded values. No user input available, therefor no SQL injection is possible.")
    private void patchKbV81LinksInTable(Connection connection, String table, String idColumn, String primaryColumns, String column, boolean relativeLink, Consumer<Integer> callback, boolean likeSyntaxSupported, Runnable updateExecutionProgress) {
        try {
            if (!HdDatabaseCheck.tableExists((DatabaseConnectionFactory)((DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class)), (String)table)) {
                return;
            }
        }
        catch (Throwable t) {
            SetupLogger.LOGGER.error(t);
        }
        int minIndex = 0;
        int maxIndex = 0;
        if (idColumn == null) {
            this.patchKbV81LinksInTableForRange(connection, table, idColumn, primaryColumns, column, relativeLink, callback, likeSyntaxSupported, updateExecutionProgress, minIndex, maxIndex);
            return;
        }
        int CHUNK_SIZE = 5000;
        BiFunction<Integer, Integer, List> generateThresholds = (min, max) -> {
            int value = min;
            ArrayList<Integer> thresholds = new ArrayList<Integer>();
            while (value < max) {
                thresholds.add(value += 5000);
            }
            thresholds.add((Integer)max);
            return thresholds;
        };
        try (Statement stmt = connection.createStatement();
             ResultSet minAndMax = stmt.executeQuery("select min(" + idColumn + "), max(" + idColumn + ") from " + table);){
            if (!minAndMax.next()) {
                SetupLogger.LOGGER.warn((Object)("No entry found in " + table + "!"));
                return;
            }
            int min2 = minAndMax.getInt(1);
            int max2 = minAndMax.getInt(2);
            List chunkThresholds = generateThresholds.apply(min2, max2);
            int current = min2;
            for (Integer threshold : chunkThresholds) {
                minIndex = current;
                maxIndex = threshold;
                this.patchKbV81LinksInTableForRange(connection, table, idColumn, primaryColumns, column, relativeLink, callback, likeSyntaxSupported, updateExecutionProgress, current, maxIndex);
                current = threshold + 1;
            }
        }
        catch (SQLException e) {
            SetupLogger.LOGGER.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is build with hard coded values. No user input available, therefor no SQL injection is possible.")
    private void patchKbV81LinksInTableForRange(Connection connection, String table, String idColumn, String primaryColumns, String column, boolean relativeLink, Consumer<Integer> callback, boolean likeSyntaxSupported, Runnable updateExecutionProgress, int minIndex, int maxIndex) {
        String sql = "SELECT " + primaryColumns + ", " + column + " FROM " + table;
        if (idColumn != null) {
            sql = sql + " WHERE " + idColumn + " BETWEEN " + minIndex + " AND " + maxIndex;
        }
        if (likeSyntaxSupported) {
            sql = idColumn == null ? sql + " WHERE" : sql + " AND";
            sql = sql + " " + column + " LIKE '%href=%/htmlclient/knowledgebase/%' OR " + column + " LIKE '%href=\"knowledgebase\"%'";
        }
        try (Statement st = connection.createStatement(1005, 1008);
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                try {
                    String content = rs.getString(column);
                    if (content != null) {
                        if (relativeLink) {
                            m = this.kbPatternV_8_1_relativekb.matcher(content);
                            sb = new StringBuffer(content.length());
                            foundMatch = false;
                            while (m.find()) {
                                foundMatch = true;
                                linkStart = m.group(1);
                                href = m.group(2);
                                linkEnd = m.group(3);
                                if ("knowledgebase".equals(href)) {
                                    href = "";
                                }
                                m.appendReplacement(sb, Matcher.quoteReplacement(linkStart + (String)href + linkEnd));
                            }
                            m.appendTail(sb);
                            if (foundMatch) {
                                rs.updateString(column, sb.toString());
                                rs.updateRow();
                                if (callback != null) {
                                    callback.accept(rs.getInt(primaryColumns));
                                }
                            }
                        } else {
                            m = this.kbPatternV_8_1_htmlclient.matcher(content);
                            sb = new StringBuffer(content.length());
                            foundMatch = false;
                            while (m.find()) {
                                foundMatch = true;
                                linkStart = m.group(1);
                                href = m.group(2);
                                linkEnd = m.group(3);
                                int indexOfHtmlClientContext = ((String)href).indexOf("/htmlclient/");
                                if (indexOfHtmlClientContext >= 0) {
                                    String hrefStart = ((String)href).substring(0, indexOfHtmlClientContext);
                                    String hrefEnd = ((String)href).substring(indexOfHtmlClientContext + "/htmlclient".length());
                                    href = hrefStart + hrefEnd;
                                }
                                m.appendReplacement(sb, Matcher.quoteReplacement(linkStart + (String)href + linkEnd));
                            }
                            m.appendTail(sb);
                            if (foundMatch) {
                                rs.updateString(column, sb.toString());
                                rs.updateRow();
                                if (callback != null) {
                                    callback.accept(rs.getInt(primaryColumns));
                                }
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    SetupLogger.LOGGER.warn((Object)("Could not update knowledge base links in table '" + table + "'."));
                    SetupLogger.LOGGER.warn((Object)t);
                }
                updateExecutionProgress.run();
            }
        }
        catch (Throwable t) {
            SetupLogger.LOGGER.warn((Object)("Could not read entries with knowledge base links from table '" + table + "'."));
            SetupLogger.LOGGER.warn((Object)t);
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5555);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> KnowledgeBaseServerPlugin.MSG.getMsg("setup.info", new Object[0]);
    }
}

