/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.InitResponseData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.KnowledgeBasePermissions;
import com.inet.helpdesk.shared.model.FieldInformation;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.util.HashMap;

public class InitKnowledgeBaseHandler
extends AbstractKnowledgeBaseHandler<Void, InitResponseData> {
    public String getMethodName() {
        return "web_knowledgebase_init";
    }

    @Override
    protected InitResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        HashMap viewConfig = new HashMap();
        String viewConfigValue = (String)currentUser.getValue(KnowledgeBaseServerPlugin.USERFIELD_KNOWLEDGEBASEVIEWCONFIG);
        if (viewConfigValue != null && !viewConfigValue.isEmpty()) {
            viewConfig = (HashMap)new Json().fromJson(viewConfigValue, HashMap.class);
        }
        ServerValuesConnector serverValuesConnector = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
        boolean canViewArticles = SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE});
        boolean canViewSupporterArticles = SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_SUPPORTER});
        boolean canViewLocationArticles = SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_ALL_LOCATIONS});
        boolean canEditArticles = SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE});
        KnowledgeBasePermissions knowledgeBasePermissions = new KnowledgeBasePermissions(canViewArticles, canViewSupporterArticles, canViewLocationArticles, canEditArticles);
        FieldInformation fi = new FieldInformation(ClientLocale.getThreadLocale().getLanguage());
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_TITLE.name(), this.translate(Article.ArticleKeys.ARTICLE_TITLE));
        fi.addFieldMaxLength(Article.ArticleKeys.ARTICLE_TITLE.name(), 255);
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_CATEGORYID.name(), Tickets.FIELD_CATEGORY_ID.getLabel());
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_LANGUAGEID.name(), HDUsersAndGroups.FIELD_LANGUAGE.getLabel());
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_PUBLISHSTATE.name(), this.translate(Article.ArticleKeys.ARTICLE_PUBLISHSTATE));
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_LOCATIONID.name(), HDUsersAndGroups.FIELD_LOCATION_ID.getLabel());
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_PROBLEM.name(), this.translate(Article.ArticleKeys.ARTICLE_PROBLEM));
        fi.addFieldMaxLength(Article.ArticleKeys.ARTICLE_PROBLEM.name(), 0x3FFFFFFF);
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_SOLUTION.name(), this.translate(Article.ArticleKeys.ARTICLE_SOLUTION));
        fi.addFieldMaxLength(Article.ArticleKeys.ARTICLE_SOLUTION.name(), 0x3FFFFFFF);
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_REFTICKETID.name(), this.translate(Article.ArticleKeys.ARTICLE_REFTICKETID));
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_LASTMODIFIED.name(), this.translate(Article.ArticleKeys.ARTICLE_LASTMODIFIED));
        fi.addFieldDisplayName(Article.ArticleKeys.ARTICLE_LASTEDITORID.name(), this.translate(Article.ArticleKeys.ARTICLE_LASTEDITORID));
        InitResponseData initResponseData = new InitResponseData(viewConfig, knowledgeBasePermissions, fi, ContextType.enduser);
        Font defaultFont = serverValuesConnector.getDefaultFont();
        if (defaultFont != null) {
            initResponseData.setDefaultFontFamily(defaultFont.getFamily());
            initResponseData.setDefaultFontSize(defaultFont.getSize() + "pt");
        }
        return initResponseData;
    }

    private String translate(Article.ArticleKeys articleKey) {
        return KnowledgeBaseServerPlugin.MSG.getMsg("Field." + articleKey.name(), new Object[0]);
    }
}

