/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.taskplanner.action;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import javax.annotation.Nullable;

public class CreateKnowledgeBaseEntryAction
extends ResultAction {
    private final int ticketId;
    private final int categoryId;
    private final String languageId;
    private final PublishState publishState;
    private final String title;
    private final String problem;
    private final String solution;
    private final GUID taskID;
    private final int locationId;

    public CreateKnowledgeBaseEntryAction(int ticketId, int categoryId, String languageId, PublishState publishState, String title, String problem, String solution, @Nullable GUID taskID, int locationId) {
        this.ticketId = ticketId;
        this.categoryId = categoryId;
        this.languageId = languageId;
        this.publishState = publishState;
        this.title = title;
        this.problem = problem;
        this.solution = solution;
        this.taskID = taskID;
        this.locationId = locationId;
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        try {
            UserAccount current;
            KnowledgeBaseConnector connector = this.getKnowledgeBaseConnector();
            if (connector == null) {
                throw new IllegalStateException("KnowledgeBaseConnector not available");
            }
            Article article = new Article();
            article.setRefTicketId(this.ticketId);
            article.setCategoryId(this.categoryId);
            article.setLanguageId(this.languageId);
            article.setPublishState(this.publishState);
            article.setTitle(this.title);
            article.setProblem(this.problem);
            article.setSolution(this.solution);
            article.setLastModified(System.currentTimeMillis());
            if (this.publishState == PublishState.LOCATION) {
                article.setLocationId(this.locationId);
            }
            if ((current = UserManager.getInstance().getCurrentUserAccount()) != null) {
                article.setLastEditorId(HDUsersAndGroups.getUserID((UserAccount)current));
            }
            connector.createArticle(article);
            this.setProgress(100);
        }
        catch (Exception ex) {
            KnowledgeBaseServerPlugin.LOGGER.error("Error while creating knowledge-base entry", (Throwable)ex);
            throw new TaskExecutionException((Throwable)ex, (ErrorCode)TaskPlannerCodes.GenericExecutionError);
        }
    }

    protected KnowledgeBaseConnector getKnowledgeBaseConnector() {
        return (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
    }
}

