/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.structure;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.plugins.knowledgebase.api.KBConfigKeys;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.plugin.ai.api.AIProviderManager;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KBAIStructureProvider
extends AbstractStructureProvider {
    private static final String CATEGORY_GROUP_AI = "categorygroup.ai";
    private static final String CATEGORY_AI_TICKETLIST = "category.ai.ticketlist";
    private static final String PROP_GROUP_KB_ENTRY = "group.ai.ticketlist.kbentry";
    private static final ConfigValue<String> AI_PROVIDERS = new ConfigValue(AIProviderManager.AI_PROVIDERS);

    public KBAIStructureProvider() {
        super("com.inet.helpdesk.plugins.knowledgebase.structure.i18n.ConfigStructure");
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (CATEGORY_AI_TICKETLIST.equals(categoryKey)) {
            propertyGroups.add(new ConfigPropertyGroup(130, PROP_GROUP_KB_ENTRY, this.translate(settings, PROP_GROUP_KB_ENTRY, new Object[0])));
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> properties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.ai.ticketlist.kbentry": {
                this.addProviderSettingsTo(properties, settings, KBConfigKeys.AI_KB_ENTRY_USEDEFAULTPROVIDER, KBConfigKeys.AI_KB_ENTRY_MANUALPROVIDER);
                this.addTo(properties, KBConfigKeys.KB_ENTRY_EXTRA_INSTRUCTIONS_KEY, "MultiLineText", settings);
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (CATEGORY_AI_TICKETLIST.equals(categoryKey)) {
            ConfigCondition kbEntryCondition = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{KBConfigKeys.AI_KB_ENTRY_USEDEFAULTPROVIDER.getKey(), "false"});
            actions.add(new ConfigConditionAction(ConfigConditionAction.Action.Visible, KBConfigKeys.AI_KB_ENTRY_MANUALPROVIDER.getKey(), kbEntryCondition));
        }
    }

    private void addProviderSettingsTo(@Nonnull Set<ConfigProperty> properties, @Nonnull ConfigStructureSettings settings, @Nonnull ConfigKey useDefaultKey, @Nonnull ConfigKey manualProviderKey) {
        ArrayList configuredProviders;
        this.addBooleanTo(properties, useDefaultKey, settings);
        ArrayList providerOptions = new ArrayList();
        try {
            String json = (String)AI_PROVIDERS.get();
            configuredProviders = (ArrayList)new Json().fromJson(json, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class}), new HashMap());
        }
        catch (Exception e) {
            configuredProviders = new ArrayList();
        }
        configuredProviders.forEach(props -> {
            String displayName = (String)props.get("displayname");
            if (displayName != null && !displayName.isBlank()) {
                providerOptions.add(new LocalizedKey(displayName, displayName));
            }
        });
        this.addSelectTo(properties, manualProviderKey, settings, providerOptions);
    }
}

