/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.Category;
import com.inet.helpdesk.plugins.knowledgebase.api.Feedback;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachment;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseUtils;
import com.inet.helpdesk.plugins.knowledgebase.server.Location;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.DataHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.ArticleDetails;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.LoadArticleDetailsRequestData;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.LoadArticleDetailsResponseData;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LoadArticleDetails
extends AbstractKnowledgeBaseHandler<LoadArticleDetailsRequestData, LoadArticleDetailsResponseData> {
    public String getMethodName() {
        return "web_knowledgebase_loadarticledetails";
    }

    @Override
    protected LoadArticleDetailsResponseData handleRequest(HttpServletRequest request, HttpServletResponse response, LoadArticleDetailsRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        Article article = this.getArticleIfPermitted(input.getArticleId(), currentUser);
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        Set<Integer> favoriteArticleIds = knowledgeBaseConnector.getFavoriteArticleIds(HDUsersAndGroups.getUserID((UserAccount)currentUser));
        CategoryVO categoryVO = (CategoryVO)CategoryManager.getInstance().get(article.getCategoryId());
        Category category = null;
        if (categoryVO == null) {
            HashSet<Integer> articleIds = new HashSet<Integer>();
            articleIds.add(input.getArticleId());
            for (Category cat : knowledgeBaseConnector.getAllDeletedCategories(currentUser, articleIds)) {
                if (cat.getId() != article.getCategoryId()) continue;
                category = new Category(cat.getId(), cat.getKey(), cat.getDisplayName());
                break;
            }
        } else {
            String categoryDisplayName = categoryVO.getDisplayValue();
            if (categoryVO.isDeleted()) {
                categoryDisplayName = KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.category.deleted", new Object[]{categoryDisplayName});
            }
            category = new Category(categoryVO.getId(), categoryVO.getPath(), categoryDisplayName);
        }
        ArrayList<Entry> locations = DataHandler.getLocationEntries();
        Location location = this.findLocation(locations, article.getLocationId());
        Feedback feedBack = knowledgeBaseConnector.getFeedback(article.getArticleId(), HDUsersAndGroups.getUserID((UserAccount)currentUser));
        boolean favorite = favoriteArticleIds.contains(article.getArticleId());
        List<KnowledgeBaseAttachment> attachments = null;
        if (spm.isPluginLoaded("attachments")) {
            KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)spm.getSingleInstance(KnowledgeBaseAttachmentConnector.class);
            attachments = kbac.getAttachments(input.getArticleId(), false);
        }
        ArticleDetails articleDetails = new ArticleDetails();
        articleDetails.setArticleId(article.getArticleId());
        articleDetails.setTitle(article.getTitle());
        articleDetails.setProblem(KnowledgeBaseUtils.convertAttachmentPathsToClient(article.getProblem()));
        articleDetails.setSolution(KnowledgeBaseUtils.convertAttachmentPathsToClient(article.getSolution()));
        articleDetails.setPublishState(article.getPublishState());
        articleDetails.setLanguageId(article.getLanguageId());
        int refTicketId = article.getRefTicketId();
        if (refTicketId != -1) {
            if (spm.isPluginLoaded("ticketlist")) {
                TicketPermissionContext ticketPermissionInfo;
                TicketDataConnector tdc = (TicketDataConnector)spm.getSingleInstance(TicketDataConnector.class);
                Ticket ticket = tdc.getTicket(ContextType.supporter, refTicketId, TicketDataConnector.TicketText.NONE);
                if (ticket != null && !(ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getId())).hasAnyAccessToTicket()) {
                    ticket = null;
                }
                if (ticket == null) {
                    refTicketId = -1;
                } else {
                    articleDetails.setRefTicketSubject((String)ticket.getValue(Field.TICKETDATA_SUBJECT, String.class));
                }
            } else {
                refTicketId = -1;
            }
        }
        articleDetails.setRefTicketId(refTicketId);
        articleDetails.setLocation(location);
        articleDetails.setCategory(category);
        int lastEditorId = article.getLastEditorId();
        UserAccount userAccount = HDUsersAndGroups.getUserAccount((int)lastEditorId);
        if (userAccount != null) {
            articleDetails.setLastEditor(userAccount.getID().toString());
        }
        articleDetails.setLastModified(article.getLastModified());
        articleDetails.setFeedBack(feedBack);
        articleDetails.setPinned(article.isPinned());
        articleDetails.setFavorite(favorite);
        articleDetails.setAttachments(attachments);
        return new LoadArticleDetailsResponseData(articleDetails);
    }

    private Location findLocation(ArrayList<Entry> data, int locationId) {
        if (data == null) {
            return null;
        }
        for (Entry e : data) {
            if (e.getId() != locationId) continue;
            return new Location(e.getId(), e.getDisplayName());
        }
        return null;
    }
}

