/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.api;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.Category;
import com.inet.helpdesk.plugins.knowledgebase.api.Feedback;
import com.inet.search.FuzzySearch;
import com.inet.search.SuggestedValue;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.IndexerStatus;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public interface KnowledgeBaseConnector {
    public ArticleSearchResult getFrontArticles(UserAccount var1, int var2, String var3, int var4, int var5) throws ServerDataException;

    public List<SuggestedValue> getSuggestedValues(String var1);

    public ArticleSearchResult searchArticles(UserAccount var1, String var2, String var3, int var4, String var5, int var6) throws ServerDataException;

    public Set<Integer> getFavoriteArticleIds(int var1) throws ServerDataException;

    public List<Category> getArticleCategories(UserAccount var1, Set<Integer> var2, int var3) throws ServerDataException;

    public Article getArticle(int var1) throws ServerDataException;

    public void saveFeedback(int var1, boolean var2, int var3) throws ServerDataException;

    public void savePinState(int var1, boolean var2) throws ServerDataException;

    public void saveFavState(int var1, boolean var2, int var3) throws ServerDataException;

    public Feedback getFeedback(int var1, int var2) throws ServerDataException;

    public void deleteArticle(int var1) throws ServerDataException;

    public int createArticle(Article var1) throws ServerDataException;

    public void updateArticle(Article var1) throws ServerDataException;

    public KnowledgeBaseIndexer getIndexer();

    public ArrayList<Integer> getArticleLocations() throws ServerDataException;

    public List<Integer> getArticlesUsingLocation(List<LocationVO> var1) throws ServerDataException;

    public ArrayList<Category> getAllDeletedCategories(UserAccount var1, Set<Integer> var2) throws ServerDataException;

    public FuzzySearch<Integer> createFuzzySearch(Article.ArticleKeys ... var1);

    public void updateArticleCacheAndIndex(int var1) throws ServerDataException;

    @Nonnull
    public IndexSearchEngine<Integer> getSearchEngine();

    public static interface KnowledgeBaseIndexer {
        public void reIndex();

        public int getIndexCount();

        public boolean isRunning();

        public IndexerStatus getIndexerStatus();
    }
}

