/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.setup;

import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.ArticleSearchResult;
import com.inet.helpdesk.plugins.knowledgebase.api.PublishState;
import com.inet.helpdesk.plugins.knowledgebase.server.KnowledgeBaseConnectorImpl;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PublicArticleMigrationStep
extends AutoSetupStep {
    private KnowledgeBaseConnectorImpl knowledgeBaseConnector;

    public PublicArticleMigrationStep(KnowledgeBaseConnectorImpl knowledgeBaseConnector) {
        this.knowledgeBaseConnector = knowledgeBaseConnector;
    }

    public StepKey stepKey() {
        return new StepKey("knowledgebase.migrate.publicarticles");
    }

    public Version getMigrationVersion() {
        return new Version("23.4");
    }

    public String getStepDisplayName() {
        return KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.migrate.publicarticles.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try {
            this.knowledgeBaseConnector.initialize();
            try (UserAccountScope priv = UserAccountScope.createPrivileged();){
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                List allCategories = CategoryManager.getInstance().getAll(true);
                List collect = allCategories.stream().filter(c -> this.isHidden((CategoryVO)c)).collect(Collectors.toList());
                for (CategoryVO categoryVO : collect) {
                    ArticleSearchResult searchResult = this.knowledgeBaseConnector.searchArticles(userAccount, "", null, categoryVO.getId(), null, Integer.MAX_VALUE);
                    for (Article article : searchResult.getArticles()) {
                        if (article.getPublishState() != PublishState.ALL || article.getCategoryId() != categoryVO.getId()) continue;
                        article.setPublishState(PublishState.SUPPORTER);
                        this.knowledgeBaseConnector.updateArticle(article);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
    }

    public boolean isHidden(@Nonnull CategoryVO category) {
        CategoryVO parent;
        if (category.isHidden()) {
            return true;
        }
        Integer parentCategoryID = category.getParentCategoryID();
        if (parentCategoryID != null && parentCategoryID != 0 && (parent = (CategoryVO)CategoryManager.getInstance().get(parentCategoryID.intValue())) != null) {
            return this.isHidden(parent);
        }
        return false;
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5777);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.migrate.publicarticles.info", new Object[0]);
    }
}

