/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.knowledgebase.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.knowledgebase.KnowledgeBaseServerPlugin;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseAttachmentConnector;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.AbstractKnowledgeBaseHandler;
import com.inet.helpdesk.plugins.knowledgebase.server.handler.data.DeleteArticleRequestData;
import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class DeleteArticle
extends AbstractKnowledgeBaseHandler<DeleteArticleRequestData, Void> {
    public String getMethodName() {
        return "web_knowledgebase_deletearticle";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, DeleteArticleRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        this.getArticleIfPermitted(input.getArticleId(), currentUser);
        if (!SystemPermissionChecker.checkAccess((Permission)KnowledgeBaseServerPlugin.KNOWLEDGE_BASE_EDIT_DELETE)) {
            throw new ClientMessageException(KnowledgeBaseServerPlugin.MSG.getMsg("knowledgebase.forbidden.edit", new Object[0]));
        }
        KnowledgeBaseConnector knowledgeBaseConnector = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        knowledgeBaseConnector.deleteArticle(input.getArticleId());
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            KnowledgeBaseAttachmentConnector kbac = (KnowledgeBaseAttachmentConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseAttachmentConnector.class);
            kbac.deleteAllAttachments(input.getArticleId());
        }
        return null;
    }
}

