/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg.imageio;

import de.digitalcollections.openjpeg.OpenJpeg;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenJp2ImageReaderSpi
extends ImageReaderSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenJp2ImageReaderSpi.class);
    private static final byte[] HEADER_MAGIC = new byte[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, -121, 10};
    private static final String vendorName = "M\u00fcnchener Digitalisierungszentrum/Digitale Bibliothek, Bayerische Staatsbibliothek";
    private static final String version = "0.2.6";
    private static final String readerClassName = "de.digitalcollections.openjpeg.imageio.OpenJp2ImageReader";
    private static final String[] names = new String[]{"jpeg2000"};
    private static final String[] suffixes = new String[]{"jp2"};
    private static final String[] MIMETypes = new String[]{"image/jp2"};
    private static final String[] writerSpiNames = new String[]{"de.digitalcollections.openjpeg.imageio.OpenJp2ImageWriterSpi"};
    private static final Class<?>[] inputTypes = new Class[]{ImageInputStream.class};
    private OpenJpeg lib;

    public OpenJp2ImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    private void loadLibrary() throws IOException {
        if (this.lib == null) {
            try {
                this.lib = new OpenJpeg();
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warn("Could not load libopenjp2, plugin will be disabled");
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            input = ImageIO.createImageInputStream(input);
        }
        if (input == null) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)input;
        byte[] b = new byte[12];
        try {
            stream.mark();
            stream.readFully(b);
        }
        catch (IOException e) {
            return false;
        }
        return Arrays.equals(b, HEADER_MAGIC);
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        this.loadLibrary();
        return new OpenJp2ImageReader(this, this.lib);
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG2000 reader plugin based on the OpenJp2 library from the OpenJPEG project.";
    }
}

