/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg.imageio;

import de.digitalcollections.openjpeg.InStreamWrapper;
import de.digitalcollections.openjpeg.OpenJpeg;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import jnr.ffi.Pointer;

class ImageInputStreamWrapper
extends InStreamWrapper {
    private final ImageInputStream is;

    ImageInputStreamWrapper(ImageInputStream is, OpenJpeg lib) {
        super(lib.lib);
        this.is = is;
    }

    @Override
    protected long read(Pointer outBuffer, long numBytes, Pointer userData) {
        byte[] buf = new byte[(int)numBytes];
        try {
            int read = this.is.read(buf, 0, (int)numBytes);
            if (read <= 0) {
                return read;
            }
            outBuffer.put(0L, buf, 0, read);
            return read;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    protected long skip(long numBytes, Pointer userData) {
        try {
            return this.is.skipBytes(numBytes);
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

