/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.ticket;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.id.GUID;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldAffectedAssets
extends TicketField<List<GUID>> {
    public static final String KEY = "affectedassets";

    public TicketFieldAffectedAssets() {
        super(KEY, null, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<List<GUID>> createFieldType() {
        return new FieldType<List<GUID>>(KEY, () -> this.getLabel()){

            @Nullable
            public String getDisplayValue(@Nullable List<GUID> value) {
                if (value == null) {
                    return null;
                }
                return value.stream().map(id -> AssetFields.FIELD_PARENT.getDisplayValue((GUID)id)).collect(Collectors.joining(","));
            }

            public SearchTag createSearchTag(Supplier<String> labelProvider, FieldTypeFactory factory) {
                return new SearchTag(TicketFieldAffectedAssets.KEY, (SearchTokenizer)new CollectionSearchTokenizer(), 100, labelProvider);
            }
        };
    }

    @Nonnull
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(@Nonnull TicketVOSingle master, @Nonnull TicketVOSingle slave) {
        return slave;
    }

    public List<GUID> copyValue(List<GUID> value) {
        if (value == null) {
            return null;
        }
        return new ArrayList<GUID>(value);
    }

    public String getLabel() {
        return AssetManager.MSG.getMsg("inventory.ticket.field.affectedassets", new Object[0]);
    }

    public OperationNewReaStep createStringFieldChangeReaStep(List<GUID> oldFieldValue, List<GUID> newFieldValue, @Nullable MutableReaStepData additionalReaStepData, OperationChangedTicket ticket) {
        String description;
        String action;
        if (oldFieldValue == null) {
            oldFieldValue = Collections.emptyList();
        }
        if (newFieldValue == null) {
            newFieldValue = Collections.emptyList();
        }
        ArrayList<GUID> added = new ArrayList<GUID>(newFieldValue);
        added.removeAll(oldFieldValue);
        ArrayList<GUID> removed = new ArrayList<GUID>(oldFieldValue);
        removed.removeAll(newFieldValue);
        MutableReaStepData data = new MutableReaStepData();
        if (!added.isEmpty() && removed.isEmpty()) {
            action = AssetManager.MSG.getMsg("inventory.ticket.field.affected.change.add", new Object[]{added.size()});
            description = this.valueToString(added);
        } else if (added.isEmpty() && !removed.isEmpty()) {
            action = AssetManager.MSG.getMsg("inventory.ticket.field.affected.change.remove", new Object[]{removed.size()});
            description = this.valueToString(removed);
        } else {
            action = AssetManager.MSG.getMsg("inventory.ticket.field.affected.change.change", new Object[0]);
            String addedStr = added.size() == 1 ? this.valueToString(added) : String.valueOf(added.size());
            String removedStr = removed.size() == 1 ? this.valueToString(removed) : String.valueOf(removed.size());
            description = AssetManager.MSG.getMsg("inventory.ticket.field.affected.change.change.detail", new Object[]{addedStr, removedStr});
        }
        data.put((ReaStepField)ReaStepVO.FIELD_ACTION_LABEL, (Object)action);
        data.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)description);
        data.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)ProcessingTime.of((long)((Long)ticket.getAttributeValue((TicketAttribute)Tickets.ATTRIBUTE_LAST_CHANGED))));
        if (additionalReaStepData != null) {
            additionalReaStepData.getIncludedFields().forEach(f -> data.put(f, additionalReaStepData.get(f)));
        }
        return ticket.addReaStep(this.getFieldChangeReaStepActionId(), data, MutableReaStepText.empty());
    }

    public int getFieldChangeReaStepActionId() {
        return -39;
    }
}

