/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.maintenance.cache;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.IndexerStatus;

@JsonData
public class InventoryCacheAction
extends MaintenanceCacheAction {
    private transient IndexerStatus indexerStatus;

    public InventoryCacheAction() {
        super("reloadInventoryCache");
    }

    public void updateAction() {
        IndexSearchEngine engine = AssetManager.getInstance().getSearchEngine();
        boolean isRunning = engine.isReindexRunning();
        int count = engine.getIndexCountOfIDs();
        this.indexerStatus = engine.getIndexerStatus((long)count);
        this.setDefaultState(isRunning);
    }

    public String executeAction() throws ClientMessageException {
        AssetManager.getInstance().maintenance().clearCacheAndReIndex();
        return InventoryCacheAction.getDefaultExecuteActionMessage();
    }

    IndexerStatus getStatus() {
        return this.indexerStatus;
    }
}

