/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select_Int;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLAManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AssetFieldSLA
extends AssetField_Select_Int
implements AssetFieldWithFieldGroup,
AssetFieldWithIcon<Integer> {
    public AssetFieldSLA(String key, int sortPrio) {
        super(key, null, sortPrio);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List all = AssetSLAManager.getInstance().getAll(!includeDeleted);
        ArrayList arrayList = all.stream().map(dt -> this.selectOption((AssetSLA)((Object)dt))).collect(Collectors.toCollection(ArrayList::new));
        arrayList.add(0, new SelectOption(null, ""));
        return arrayList;
    }

    @Override
    public SelectOptionResult getOptions(AssetVO device, String searchTerm, int currentSize, int chunkSize) {
        HashMap options = new HashMap();
        this.getSelectOptions().forEach(op -> options.put(op.getValue(), op.getLabel()));
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, options, (value, displayName) -> new SelectOption(StringFunctions.stringValueOf((Object)value), displayName, String.valueOf(value)));
    }

    private SelectOption selectOption(AssetSLA slaVo) {
        return new SelectOption(String.valueOf(slaVo.getId()), slaVo.getDisplayValue(), String.valueOf(slaVo.getId()));
    }

    @Override
    public SelectOption getValue(AssetView device) {
        AssetSLA assetSLA;
        Integer value = device != null ? device.getValue(this) : (Integer)this.getDefaultValue();
        if (value != null && (assetSLA = (AssetSLA)AssetSLAManager.getInstance().get(value)) != null) {
            return this.selectOption(assetSLA);
        }
        return null;
    }

    @Override
    public void validateRealValue(Integer id) throws FieldValidationException {
        if (id != null && AssetSLAManager.getInstance().get(id) == null) {
            throw new FieldValidationException(AssetManager.MSG.getMsg("manager.error.objectDoesNotExist", new Object[]{id}));
        }
    }

    @Override
    public String getDisplayValue(Integer value) {
        AssetSLA sla = (AssetSLA)AssetSLAManager.getInstance().get(value);
        if (sla != null) {
            return sla.getDisplayValue();
        }
        return null;
    }

    @Override
    public URL getIcon(String value, int size) {
        try {
            int type = Integer.parseInt(value);
            return AssetSLAManager.getInstance().getIcon(type, size);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getIcon(value, size);
        }
    }

    @Override
    @Nullable
    public LocalizedKey getFieldGroup() {
        return new LocalizedKey(this.getFieldKey(), this.getLabel());
    }

    @Override
    public List<AssetFieldWithFieldGroup.AdditionalDetailField> getAdditionalFields(String serializedValue) {
        UserGroupInfo resource;
        AssetSLA assetSLA;
        MutableAssetData data = new MutableAssetData();
        this.getEditInformation().updateAssetData(data, serializedValue);
        Integer value = data.get(this);
        AssetSLA assetSLA2 = assetSLA = value == null ? null : (AssetSLA)AssetSLAManager.getInstance().get(value);
        if (assetSLA == null) {
            return null;
        }
        ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField> fields = new ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField>();
        String resourceName = "";
        Integer res = assetSLA.getResID();
        if (res != null && (resource = HDUsersAndGroups.getResource((int)res)) != null) {
            resourceName = resource.getDisplayName();
        }
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("resource", 1, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.sla.row.resource", new Object[0]), resourceName));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("agreement", 2, true, InventoryServerPlugin.CONFIG_MSG.getMsg("field.sla.row.agreement", new Object[0]), assetSLA.getSLA()));
        return fields;
    }
}

