/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryAttachment;
import com.inet.helpdesk.plugins.inventory.client.data.SaveAssetRequest;
import com.inet.helpdesk.plugins.inventory.client.data.SaveAssetResponse;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SaveAsset
extends AbstractInventoryHandler<SaveAssetRequest, SaveAssetResponse> {
    public String getMethodName() {
        return "inventory.saveasset";
    }

    @Override
    public SaveAssetResponse handle(HttpServletRequest req, HttpServletResponse resp, SaveAssetRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        AssetView asset = null;
        GUID id = GUID.valueOf((String)payload.getId());
        if (id != null && (asset = AssetManager.getInstance().getAsset(id)) == null) {
            throw new ClientMessageException(InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.saveasset.noasset", new Object[0]));
        }
        AssetNodeIdentifier parentId = AssetNodeIdentifier.valueOf(payload.getParentId());
        Map<String, String> values = payload.getValues();
        MutableAssetData data = new MutableAssetData();
        AssetFields.FIELD_TYPE.getEditInformation().updateAssetData(data, values.get(AssetFields.FIELD_TYPE.getFieldKey()));
        Integer typeId = data.get(AssetFields.FIELD_TYPE);
        if (typeId == null && asset != null) {
            typeId = asset.getValue(AssetFields.FIELD_TYPE);
        }
        if (typeId == null) {
            throw new ClientMessageException(InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.saveasset.notype", new Object[0]));
        }
        data.put(AssetFields.FIELD_IMAGE, values.get(AssetFields.FIELD_IMAGE.getKey()));
        List deviceFields = DynamicExtensionManager.getInstance().get(AssetField.class);
        for (AssetField field : deviceFields) {
            FieldEditInformation editInformation;
            AssetFieldWithDefinition fieldWithDefinition;
            if (!(field instanceof AssetFieldWithDefinition) || !(fieldWithDefinition = (AssetFieldWithDefinition)field).isVisibleInType(typeId) || (editInformation = fieldWithDefinition.getEditInformation()) == null) continue;
            editInformation.updateAssetData(data, values.get(fieldWithDefinition.getFieldKey()));
        }
        ArrayList<AssetManager.AdditionalTask> extensionTasks = new ArrayList<AssetManager.AdditionalTask>();
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            if (payload.getCopiedAttachments() != null) {
                extensionTasks.add((updatedAsset, historyAdder) -> {
                    InventoryAttachments.saveAttachment(updatedAsset, payload.getCopiedAttachments());
                    long currentTimeMillis = System.currentTimeMillis();
                    GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
                    for (InventoryAttachment att : payload.getCopiedAttachments()) {
                        historyAdder.accept(new HistoryStep(updatedAsset.getIntID(), currentTimeMillis, currentUserAccountID, AssetManager.MSG.getMsg("attachment.history.add", new Object[]{att.getFileName()})));
                    }
                });
            }
            if (payload.getAttachments() != null && !payload.getAttachments().isEmpty()) {
                extensionTasks.add((updatedAsset, historyAdder) -> {
                    InventoryAttachments.saveAttachment(updatedAsset, payload.getAttachments(), req);
                    long currentTimeMillis = System.currentTimeMillis();
                    GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
                    for (AttachmentDescription att : payload.getAttachments()) {
                        historyAdder.accept(new HistoryStep(updatedAsset.getIntID(), currentTimeMillis, currentUserAccountID, AssetManager.MSG.getMsg("attachment.history.add", new Object[]{att.getName()})));
                    }
                });
            }
            if (asset != null && payload.getDeletedAttachments() != null && !payload.getDeletedAttachments().isEmpty()) {
                int intID = asset.getIntID();
                extensionTasks.add((updatedAsset, historyAdder) -> {
                    List<InventoryAttachment> deletedAttachments = payload.getDeletedAttachments();
                    for (InventoryAttachment attachment : deletedAttachments) {
                        InventoryAttachments.deleteAttachment(intID, attachment.getFileName());
                        long currentTimeMillis = System.currentTimeMillis();
                        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
                        historyAdder.accept(new HistoryStep(updatedAsset.getIntID(), currentTimeMillis, currentUserAccountID, AssetManager.MSG.getMsg("attachment.history.delete", new Object[]{attachment.getFileName()})));
                    }
                });
            }
        }
        if (id == null) {
            if (parentId != null && parentId.isDevice()) {
                data.put(AssetFields.FIELD_PARENT, parentId.getDeviceId());
            }
            AssetView device = AssetManager.getInstance().createAsset(data, extensionTasks);
            id = device.getId();
        } else {
            AssetManager.getInstance().updateAsset(id, data, extensionTasks);
        }
        return new SaveAssetResponse(id);
    }
}

