/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.config.ConfigValue;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeGroupEntry;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeGroupEntryDescription;
import com.inet.helpdesk.plugins.inventory.client.data.LoadTreeGroupingSettingsResponse;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeGrouping;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class LoadTreeGroupingSettings
extends AbstractInventoryHandler<Void, LoadTreeGroupingSettingsResponse> {
    public static final ConfigValue<List<InventoryTreeGroupEntry>> GROUPING_LIST = new ConfigValue<List<InventoryTreeGroupEntry>>(InventoryServerPlugin.CONFIGKEY_GROUPING){

        protected List<InventoryTreeGroupEntry> convert(@Nonnull String strValue) throws IllegalArgumentException {
            if (StringFunctions.isEmpty((String)strValue)) {
                return Collections.emptyList();
            }
            return (List)new Json().fromJson(strValue, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{InventoryTreeGroupEntry.class}));
        }
    };

    public String getMethodName() {
        return "inventory.loadtreegroupingsettings";
    }

    @Override
    public LoadTreeGroupingSettingsResponse handle(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        List groupingConfig = (List)GROUPING_LIST.get();
        ArrayList<InventoryTreeGroupEntryDescription> groupingDescription = new ArrayList<InventoryTreeGroupEntryDescription>();
        for (InventoryTreeGroupEntry inventoryTreeGroupEntry : groupingConfig) {
            InventoryTreeGroupEntryDescription inventoryTreeGroupEntryDescription = new InventoryTreeGroupEntryDescription(inventoryTreeGroupEntry.getKey(), inventoryTreeGroupEntry.getName());
            List<String> groupingKeys = inventoryTreeGroupEntry.getGroupingKeys();
            if (groupingKeys != null) {
                for (String groupingKey : groupingKeys) {
                    AssetField deviceFiled = AssetFields.getFieldFor(groupingKey);
                    if (deviceFiled != null) {
                        inventoryTreeGroupEntryDescription.add(new LocalizedKey(deviceFiled.getKey(), deviceFiled.getLabel()));
                        continue;
                    }
                    inventoryTreeGroupEntryDescription.add(new LocalizedKey(groupingKey, groupingKey));
                }
            }
            groupingDescription.add(inventoryTreeGroupEntryDescription);
        }
        ArrayList<LocalizedKey> fieldDescriptions = new ArrayList<LocalizedKey>();
        List fields = DynamicExtensionManager.getInstance().get(AssetField.class);
        for (AssetField deviceField : fields) {
            AssetFieldWithDefinition deviceFieldWithDefinition;
            if (!(deviceField instanceof AssetFieldWithDefinition) || (deviceFieldWithDefinition = (AssetFieldWithDefinition)deviceField).getDisplayType().equals((Object)FieldSettingsType.TYPE_MULTILINE_TEXT)) continue;
            fieldDescriptions.add(new LocalizedKey(deviceFieldWithDefinition.getKey(), deviceFieldWithDefinition.getLabel()));
        }
        return new LoadTreeGroupingSettingsResponse(groupingDescription, fieldDescriptions);
    }

    public static TreeGrouping getTreeGrouping(GUID key) {
        List groupingConfig = (List)GROUPING_LIST.get();
        InventoryTreeGroupEntry groupEntry = groupingConfig.stream().filter(g -> g.getKey().equals((Object)key)).findFirst().orElse(null);
        if (groupEntry == null) {
            return new TreeGrouping(Collections.emptyList());
        }
        List<String> groupingKeys = groupEntry.getGroupingKeys();
        return new TreeGrouping(groupingKeys.stream().map(k -> AssetFields.getFieldFor(k)).filter(f -> f != null).filter(f -> f instanceof AssetFieldWithDefinition).map(f -> (AssetFieldWithDefinition)f).collect(Collectors.toList()));
    }
}

