/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.search;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventorySearchQuery;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventorySearchResponse;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.handler.AvailableSearchTags;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventorySearchHandler
extends RequestHandlerBase<InventorySearchQuery, InventorySearchResponse> {
    public InventorySearchHandler() {
        super(new String[]{"search"});
        this.registerRequestHandler((RequestHandlerBase)new AvailableSearchTags(() -> AssetManager.getInstance().getSearchEngine()));
    }

    public String getHelpPageKey() {
        return "webapi.inventory.search";
    }

    @Operation(summary="Search inventory assets", description="Searches for inventory assets based on query parameters with pagination support. Users with limited permissions will only see their own assets.", responses={@ApiResponse(responseCode="200", description="Search results retrieved successfully", content={@Content(schema=@Schema(implementation=InventorySearchResponse.class))}), @ApiResponse(responseCode="401", description="User not authorized to search assets")})
    public InventorySearchResponse handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable InventorySearchQuery inputObject, @Nonnull List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        InventorySearchQuery payload = Objects.requireNonNullElse(inputObject, InventorySearchQuery.emptyQuery());
        String query = Objects.requireNonNullElse(payload.getQuery(), "");
        AssetManager assetManager = AssetManager.getInstance();
        IndexSearchEngine searchEngine = assetManager.getSearchEngine();
        GUID userAccountId = UserManager.getInstance().getCurrentUserAccountID();
        SearchCommand commandBuilder = new TextSearchCommandBuilder(searchEngine, query).build(ClientLocale.getThreadLocale());
        boolean canAccessAll = SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL);
        if (!canAccessAll) {
            commandBuilder.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_OWNER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)userAccountId));
        } else {
            commandBuilder.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_TYPE.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        Set searchResult = searchEngine.simpleSearch(commandBuilder);
        LinkedList<GUID> entries = new LinkedList(searchResult);
        entries = entries.subList(payload.getChunkStart(), Math.min(entries.size(), payload.getChunkStart() + payload.getChunkLimit()));
        boolean partialResult = searchResult.size() > payload.getChunkStart() + payload.getChunkLimit();
        return InventorySearchResponse.from(entries, partialResult);
    }
}

