/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.asset;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetResponse;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryAssetArchivalHandler
extends RequestHandler.WithParentPathToken<Void, InventoryAssetResponse, GUID> {
    public static final String ARCHIVE = "archive";
    public static final String UNARCHIVE = "unarchive";
    public static final String UNARCHIVE_ALL = "unarchiveall";

    public InventoryAssetArchivalHandler(String archivalType) {
        super(new String[]{archivalType});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.asset." + this.getName();
    }

    @Operation(summary="Archive or unarchive an asset", description="Changes the archival state of an asset. Can archive, unarchive, or unarchive with all children. Requires write permissions.", responses={@ApiResponse(responseCode="200", description="Asset archival state changed successfully", content={@Content(schema=@Schema(implementation=InventoryAssetResponse.class))}), @ApiResponse(responseCode="400", description="Invalid asset ID or asset not found"), @ApiResponse(responseCode="401", description="User not authorized"), @ApiResponse(responseCode="403", description="User does not have write permissions")})
    public InventoryAssetResponse handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void object, @Parameter(description="GUID of the asset to change archival state") @Nullable GUID assetId, List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        if (assetId == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notGiven", new Object[0]));
        }
        AssetManager manager = AssetManager.getInstance();
        AssetView asset = manager.getAsset(assetId, true);
        if (asset == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notFound", new Object[0]));
        }
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        if (!previewModeEnabled) {
            switch (this.getName()) {
                case "archive": {
                    manager.archiveAsset(assetId);
                    break;
                }
                case "unarchive": {
                    manager.unarchiveAsset(assetId, false);
                    break;
                }
                case "unarchiveall": {
                    manager.unarchiveAsset(assetId, true);
                    break;
                }
                default: {
                    throw new ClientMessageException("Unknown archival handler type.");
                }
            }
        }
        asset = manager.getAsset(assetId, true);
        return InventoryAssetResponse.from(asset);
    }
}

