/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.ticket;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionAffectedAssets
extends AbstractTicketFieldDefinitionWithField<List<GUID>> {
    public TicketFieldDefinitionAffectedAssets(int prio) {
        super((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS, true, true, prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER);
    }

    public String getValueAsStringForIcon(@Nonnull TicketVO ticket) {
        return this.getDisplayValue(ticket);
    }

    public URL getIconForValue(String valueAsString, int size) {
        if (!StringFunctions.isEmpty((String)valueAsString)) {
            return this.getColumnIcon(size);
        }
        return null;
    }

    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_16.png");
        }
        if (iconSize <= 24) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_24.png");
        }
        if (iconSize <= 32) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_32.png");
        }
        if (iconSize <= 48) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_48.png");
        }
        if (iconSize <= 64) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_64.png");
        }
        if (iconSize <= 96) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_96.png");
        }
        if (iconSize <= 128) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_128.png");
        }
        if (iconSize <= 256) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_256.png");
        }
        return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_512.png");
    }

    public String getDisplayValue(TicketVO ticket) {
        if (ticket == null) {
            return "";
        }
        List affAssets = (List)ticket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
        if (affAssets == null || affAssets.isEmpty()) {
            return "";
        }
        int assetCount = 0;
        for (GUID id : affAssets) {
            try {
                AssetView asset = AssetManager.getInstance().getAsset(id);
                if (asset == null) continue;
                ++assetCount;
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        return assetCount == 0 ? "" : "" + assetCount;
    }

    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition((TicketFieldDefinition)this){

            public boolean isAvailable(List<TicketVO> tickets) {
                return false;
            }

            public void updateTicketData(MutableTicketData ticketData, @Nonnull Map<String, String> values) {
                String idList = values.get(this.getFieldKey());
                if (idList != null && !idList.isBlank()) {
                    ticketData.put((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS, (Object)((List)new Json().fromJson(idList, (Type)new JsonParameterizedType(List.class, new Type[]{GUID.class}))));
                }
            }

            public void updateCurrentValue(@Nullable TicketVO ticket, @Nullable GUID ownerId, @Nonnull Map<String, String> values) {
            }

            public String getFieldKey() {
                return TicketFieldDefinitionAffectedAssets.this.getKey();
            }

            public String getDisplayType() {
                return "textinput";
            }

            public String getDisplayName() {
                return TicketFieldDefinitionAffectedAssets.this.getDisplayName();
            }
        };
    }

    @Nonnull
    public Comparator<TicketVO> getComparator() {
        Comparator comp = Comparator.naturalOrder();
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

