/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.reporting.datasource;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.reporting.HDReporting;
import com.inet.helpdesk.core.reporting.server.datasource.ITicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.datasource.TicketDataResultSet;
import com.inet.helpdesk.core.reporting.server.datasource.TicketDataSourceConfiguration;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class AssetAdhocDataSource
extends BaseDataFactory {
    public static final String DATASOURCE_NAME = "Assets - Adhoc";
    public static final String TABLE_ASSETS_ADHOC = "AssetsAdhoc";
    public static final String TABLE_ASSET_IN_TICKETS = "AssetsInTickets";
    private TicketDataSourceConfiguration ticketDataSource = new TicketDataSourceConfiguration();
    public static final String PROMPT_ASSET_SEARCH_PHRASE = "AssetSearchPhraseprompt";
    public static final String COLUMN_ASSET_ID = "assetid";
    public static final String COLUMN_TICKET_ID = "ticketid";
    public static final String PREFIX_ASSET_COLUMNS = "AssetsAdhoc_";

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return Map.of(TABLE_ASSETS_ADHOC, new TableSourceInfo(null, null, TABLE_ASSETS_ADHOC, 20), TABLE_ASSET_IN_TICKETS, new TableSourceInfo(null, null, TABLE_ASSET_IN_TICKETS, 20));
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        List<Object> cols = new ArrayList<ColumnInfo>();
        if (ts.getDatabaseIdentifier().equals(TABLE_ASSETS_ADHOC)) {
            cols = this.getColumnPairs(ts.getDatabaseIdentifier(), "").stream().map(p -> (DataSourceUtils.ColumnInfoWithLabel)p.getValue()).collect(Collectors.toList());
            cols.add(new ColumnInfo(PROMPT_ASSET_SEARCH_PHRASE, 11, 1, 12, 0));
        } else if (ts.getDatabaseIdentifier().equals(TABLE_ASSET_IN_TICKETS)) {
            cols = this.getColumnPairs(ts.getDatabaseIdentifier(), PREFIX_ASSET_COLUMNS).stream().map(p -> (DataSourceUtils.ColumnInfoWithLabel)p.getValue()).collect(Collectors.toCollection(ArrayList::new));
            cols.addAll(this.ticketDataSource.getColumnPairs("TicketAdhoc").stream().map(p -> (DataSourceUtils.ColumnInfoWithLabel)p.getValue()).collect(Collectors.toList()));
            cols.add(new ColumnInfo(PROMPT_ASSET_SEARCH_PHRASE, 11, 1, 12, 0));
        }
        return cols;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> getColumnPairs(String table, String columnPrefix) {
        ArrayList<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols = new ArrayList<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>>();
        cols.add(Map.entry(columnPrefix + COLUMN_ASSET_ID, new DataSourceUtils.ColumnInfoWithLabel(columnPrefix + COLUMN_ASSET_ID, AssetManager.MSG.getMsg("datasource.column.assetid", new Object[0]), 11)));
        @Nonnull List list = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        Collections.sort(list, (d1, d2) -> d1.getPriority() - d2.getPriority());
        for (AssetFieldDefinition fieldDef : list) {
            if (fieldDef.getDisplayType() == null || fieldDef.getFieldKey() == null || fieldDef.getLabel() == null) continue;
            AssetField field = null;
            field = AssetFields.getFieldFor(fieldDef.getFieldKey());
            if (field == null) continue;
            if (DataSourceUtils.showDisplayValueForField(field)) {
                cols.add(Map.entry(columnPrefix + fieldDef.getFieldKey(), new DataSourceUtils.ColumnInfoWithLabel(columnPrefix + fieldDef.getFieldKey(), fieldDef.getLabel(), 11)));
                continue;
            }
            int reportFieldType = DataSourceUtils.apiFieldTypeToReportFieldType(field);
            cols.add(Map.entry(columnPrefix + fieldDef.getFieldKey(), new DataSourceUtils.ColumnInfoWithLabel(columnPrefix + fieldDef.getFieldKey(), fieldDef.getLabel(), reportFieldType)));
        }
        return cols;
    }

    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        List prompts = ts.getInputParameters();
        switch (ts.getDatabaseIdentifier()) {
            case "AssetsAdhoc": {
                final AssetManager um = AssetManager.getInstance();
                final Set<GUID> searchResult = this.searchAssets(prompts, um, TABLE_ASSETS_ADHOC);
                final List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols = this.getColumnPairs(ts.getDatabaseIdentifier(), "");
                SimpleResultSet rs = new SimpleResultSet(cols.stream().map(c -> ((DataSourceUtils.ColumnInfoWithLabel)c.getValue()).getName()).collect(Collectors.toList()).toArray(new String[cols.size()])){
                    private final Iterator<GUID> ids;
                    {
                        super(arg0);
                        this.ids = searchResult.iterator();
                    }

                    public boolean next() throws SQLException {
                        while (this.ids.hasNext()) {
                            GUID id = this.ids.next();
                            AssetView asset = um.getAsset(id);
                            if (asset == null) continue;
                            Object[] rowData = new Object[cols.size()];
                            for (int i = 0; i < cols.size(); ++i) {
                                Map.Entry col = (Map.Entry)cols.get(i);
                                if (((String)col.getKey()).equals(AssetAdhocDataSource.COLUMN_ASSET_ID)) {
                                    rowData[i] = asset.getId().toString();
                                    continue;
                                }
                                if (((DataSourceUtils.ColumnInfoWithLabel)col.getValue()).getColumnType() != 3) continue;
                                AssetField field = AssetFields.getFieldFor((String)col.getKey());
                                if (DataSourceUtils.showDisplayValueForField(field)) {
                                    AssetFieldDefinition def = AssetFields.getFieldDefinitionFor((String)col.getKey());
                                    rowData[i] = def.getDisplayValue(asset);
                                    continue;
                                }
                                rowData[i] = DataSourceUtils.convertFieldValueToReportingValue(asset.getValue(field), field);
                            }
                            this.getAllRows().add(rowData);
                            return super.next();
                        }
                        return false;
                    }
                };
                return new TableData((ResultSet)rs);
            }
            case "AssetsInTickets": {
                return this.assetsInTicketData(prompts);
            }
        }
        throw new ReportException("Unknown database table: " + ts.getDatabaseIdentifier(), ReportErrorCode.invalidDataSourceFile.getErrorCodeNumber());
    }

    private Set<GUID> searchAssets(List<PromptField> prompts, AssetManager um, String tableName) {
        Object value;
        String json;
        Optional<PromptField> promptField = prompts.stream().filter(f -> f.getName().equals(PROMPT_ASSET_SEARCH_PHRASE)).findFirst();
        SearchCommand command = null;
        if (promptField.isPresent() && !StringFunctions.isEmpty((String)(json = (String)(value = promptField.get().getValue())))) {
            DataViewConditions dataViewConditions = (DataViewConditions)new Json().fromJson(json, DataViewConditions.class);
            AndSearchExpression expression = AssetAdhocDataSource.buildSearchExpressionForAssetTable(dataViewConditions, tableName);
            command = new SearchCommand(new SearchExpression[]{expression});
        }
        if (command == null || command.getSearchExpression().isEmpty()) {
            command = new SearchCommand(new SearchExpression[]{new SearchCondition("deviceid", SearchCondition.SearchTermOperator.StartsWith, (Object)"")});
        }
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL)) {
            command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.FIELD_OWNER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)UserManager.getInstance().getCurrentUserAccountID()));
        }
        Set searchResult = um.getSearchEngine().simpleSearch(command);
        return searchResult;
    }

    @Nonnull
    private TableData assetsInTicketData(List<PromptField> prompts) {
        Object value;
        String json;
        Optional<PromptField> promptField = prompts.stream().filter(f -> f.getName().equals(PROMPT_ASSET_SEARCH_PHRASE)).findFirst();
        SearchCommand command = null;
        if (promptField.isPresent() && !StringFunctions.isEmpty((String)(json = (String)(value = promptField.get().getValue())))) {
            DataViewConditions dataViewConditions = (DataViewConditions)new Json().fromJson(json, DataViewConditions.class);
            AndSearchExpression expression = ITicketDataSourceConfiguration.buildSearchPhraseForTicketTable((DataViewConditions)dataViewConditions, (String)TABLE_ASSET_IN_TICKETS, AssetAdhocDataSource.joinTokenInfoForAssetsInTickets());
            command = new SearchCommand(new SearchExpression[]{expression});
        }
        if (command == null) {
            command = new SearchCommand(new SearchExpression[0]);
        }
        command.getSearchExpression().add((SearchExpression)new SearchCondition(AssetFields.TICKET_FIELD_AFFECTED_ASSETS.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        command.setResultLimit(10000);
        Set searchResult = TicketManager.getReader().getSearchEngine().simpleSearch(command);
        final AssetManager am = AssetManager.getInstance();
        final Set<GUID> foundAssets = this.searchAssets(prompts, AssetManager.getInstance(), TABLE_ASSET_IN_TICKETS);
        List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols = this.getColumnPairs(TABLE_ASSET_IN_TICKETS, PREFIX_ASSET_COLUMNS);
        cols.addAll(this.ticketDataSource.getColumnPairs("TicketAdhoc"));
        TicketDataResultSet rs = new TicketDataResultSet(searchResult, this.ticketDataSource, "TicketAdhoc", cols){
            @Nonnull
            private List<GUID> assetsForTicket;
            private AssetView asset;
            {
                super(arg0, arg1, arg2, arg3);
                this.assetsForTicket = List.of();
            }

            public boolean next() throws SQLException {
                GUID assetId;
                if (this.assetsForTicket.isEmpty()) {
                    boolean next = super.next();
                    if (!next) {
                        return false;
                    }
                    this.assetsForTicket = (List)this.ticket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
                }
                if (!foundAssets.contains(assetId = this.assetsForTicket.remove(0))) {
                    return this.next();
                }
                this.asset = am.getAsset(assetId);
                if (this.asset == null) {
                    return this.next();
                }
                return true;
            }

            public Object getObject(int columnIndex) throws SQLException {
                Map.Entry col = (Map.Entry)this.cols.get(columnIndex - 1);
                String key = (String)col.getKey();
                if (key.startsWith(AssetAdhocDataSource.PREFIX_ASSET_COLUMNS)) {
                    if ((key = key.substring(AssetAdhocDataSource.PREFIX_ASSET_COLUMNS.length())).equals(AssetAdhocDataSource.COLUMN_ASSET_ID)) {
                        return this.asset.getId().toString();
                    }
                    if (((DataSourceUtils.ColumnInfoWithLabel)col.getValue()).getColumnType() == 3) {
                        AssetField field = AssetFields.getFieldFor(key);
                        if (DataSourceUtils.showDisplayValueForField(field)) {
                            AssetFieldDefinition def = AssetFields.getFieldDefinitionFor(key);
                            return def.getDisplayValue(this.asset);
                        }
                        return DataSourceUtils.convertFieldValueToReportingValue(this.asset.getValue(field), field);
                    }
                    return null;
                }
                return super.getObject(columnIndex);
            }
        };
        return new TableData((ResultSet)rs);
    }

    public static AndSearchExpression buildSearchExpressionForAssetTable(DataViewConditions dataViewConditions, String tableName) {
        AndSearchExpression expression = DataSourceUtils.buildSearchPhraseExpression((DataViewConditions)dataViewConditions, (String)tableName, key -> {
            if (key.startsWith(PREFIX_ASSET_COLUMNS)) {
                key = key.substring(PREFIX_ASSET_COLUMNS.length());
            }
            AssetField field = AssetFields.getFieldFor(key);
            return field;
        }, (IndexSearchEngine)AssetManager.getInstance().getSearchEngine(), Map.of("UserAdhoc", new DataSourceUtils.JoinTokenInfo(UserManager.getInstance().getSearchEngine(), AssetFields.FIELD_OWNER.getKey(), fieldKey -> UsersAndGroups.getFieldByKey((String)fieldKey))));
        return expression;
    }

    public static Map<String, DataSourceUtils.JoinTokenInfo> joinTokenInfoForAssetsInTickets() {
        Map map = HDReporting.joinTokenInfoForTicketTable();
        map.put(TABLE_ASSET_IN_TICKETS, new DataSourceUtils.JoinTokenInfo(AssetManager.getInstance().getSearchEngine(), AssetFields.TICKET_FIELD_AFFECTED_ASSETS.getKey(), key -> {
            if (key.startsWith(PREFIX_ASSET_COLUMNS)) {
                key = key.substring(PREFIX_ASSET_COLUMNS.length());
            }
            return AssetFields.getFieldFor(key);
        }));
        return map;
    }
}

